/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.tc;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.entity.Code;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TCQueryFilterKey {
    Abstract("IHERADTF", "TCE104", "Abstract"),
    AcquisitionModality("DCM", "121139", "Modality"),
    Anatomy("DCM", "112005", "Radiographic Anatomy", true),
    AuthorAffiliation("IHERADTF", "TCE102", "Affiliation"),
    AuthorContact("IHERADTF", "TCE103", "Contact"),
    AuthorName("IHERADTF", "TCE101", "Author"),
    Category("IHERADTF", "TCE109", "Category"),
    Diagnosis("IHERADTF", "TCE107", "Diagnosis", true),
    DiagnosisConfirmed("IHERADTF", "TCE111", "Diagnosis confirmed"),
    DifferentialDiagnosis("DCM", "111023", "Differential Diagnosis/Impression", true),
    Discussion("IHERADTF", "TCE106", "Discussion"),
    Finding("DCM", "121071", "Finding", true),
    History("DCM", "121060", "History"),
    Keyword("IHERADTF", "TCE105", "Keywords", true),
    Level("IHERADTF", "TCE110", "Level"),
    OrganSystem("IHERADTF", "TCE108", "Organ system"),
    Pathology("DCM", "111042", "Pathology", true),
    PatientSex("AGFAIMPAXEE", "TF102", "Patient Sex"),
    PatientSpecies("AGFAIMPAXEE", "TF103", "Patient Species"),
    BibliographicReference("AGFAIMPAXEE", "TF005", "Bibliographic Reference"),
    Title("AGFAIMPAXEE", "TF001", "Title");

    private Code code;
    private boolean supportsCodeValue;

    private TCQueryFilterKey(String designator, String value, String meaning) {
        this(designator, value, meaning, false);
    }

    private TCQueryFilterKey(String designator, String value, String meaning, boolean supportsCodeValue) {
        this.code = TCQueryFilterKey.createCode(designator, value, meaning);
        this.supportsCodeValue = supportsCodeValue;
    }

    public Code getCode() {
        return this.code;
    }

    public boolean supportsCodeValue() {
        return this.supportsCodeValue;
    }

    private static Code createCode(String designator, String value, String meaning) {
        BasicDicomObject dataset = new BasicDicomObject();
        dataset.putString(524546, VR.SH, designator);
        dataset.putString(524544, VR.SH, value);
        dataset.putString(524548, VR.LO, meaning);
        return new Code((DicomObject)dataset);
    }
}

