/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.tc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dcm4chee.archive.entity.Code;
import org.dcm4chee.web.dao.tc.TCQueryFilterKey;
import org.dcm4chee.web.dao.tc.TCQueryFilterValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCQueryFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(TCQueryFilter.class);
    private Map<TCQueryFilterKey, TCQueryFilterValue<?>> values;

    public void clear() {
        if (this.values != null) {
            this.values.clear();
            this.values = null;
        }
    }

    public Set<Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>>> getEntries() {
        return this.values != null ? this.values.entrySet() : null;
    }

    public String getAbstract() {
        return (String)this.getValue(TCQueryFilterKey.Abstract);
    }

    public void setAbstract(String abstr) {
        this.putValue(TCQueryFilterKey.Abstract, abstr);
    }

    public TCQueryFilterValue.AcquisitionModality getAcquisitionModality() {
        return (TCQueryFilterValue.AcquisitionModality)this.getValue(TCQueryFilterKey.AcquisitionModality);
    }

    public void setAcquisitionModality(TCQueryFilterValue.AcquisitionModality acquisitionModality) {
        this.putValue(TCQueryFilterKey.AcquisitionModality, acquisitionModality != null ? TCQueryFilterValue.create(acquisitionModality) : null);
    }

    public String getAnatomy() {
        try {
            return (String)this.getValue(TCQueryFilterKey.Anatomy);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'anatomy' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setAnatomy(String anatomy) {
        this.putValue(TCQueryFilterKey.Anatomy, anatomy);
    }

    public String getAuthorAffiliation() {
        return (String)this.getValue(TCQueryFilterKey.AuthorAffiliation);
    }

    public void setAuthorAffiliation(String authorAffiliation) {
        this.putValue(TCQueryFilterKey.AuthorAffiliation, authorAffiliation);
    }

    public String getAuthorContact() {
        return (String)this.getValue(TCQueryFilterKey.AuthorContact);
    }

    public void setAuthorContact(String authorContact) {
        this.putValue(TCQueryFilterKey.AuthorContact, authorContact);
    }

    public String getAuthorName() {
        return (String)this.getValue(TCQueryFilterKey.AuthorName);
    }

    public void setAuthorName(String authorName) {
        this.putValue(TCQueryFilterKey.AuthorName, authorName);
    }

    public TCQueryFilterValue.Category getCategory() {
        return (TCQueryFilterValue.Category)this.getValue(TCQueryFilterKey.Category);
    }

    public void setCategory(TCQueryFilterValue.Category category) {
        this.putValue(TCQueryFilterKey.Category, category != null ? TCQueryFilterValue.create(category) : null);
    }

    public String getDiagnosis() {
        try {
            return (String)this.getValue(TCQueryFilterKey.Diagnosis);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'diagnosis' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setDiagnosis(String diagnosis) {
        this.putValue(TCQueryFilterKey.Diagnosis, diagnosis);
    }

    public TCQueryFilterValue.YesNo getDiagnosisConfirmed() {
        return (TCQueryFilterValue.YesNo)this.getValue(TCQueryFilterKey.DiagnosisConfirmed);
    }

    public void setDiagnosisConfirmed(TCQueryFilterValue.YesNo diagnosisConfirmed) {
        this.putValue(TCQueryFilterKey.DiagnosisConfirmed, diagnosisConfirmed != null ? TCQueryFilterValue.create(diagnosisConfirmed) : null);
    }

    public String getDiffDiagnosis() {
        try {
            return (String)this.getValue(TCQueryFilterKey.DifferentialDiagnosis);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'diff-diagnosis' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setDiffDiagnosis(String diffDiagnosis) {
        this.putValue(TCQueryFilterKey.DifferentialDiagnosis, diffDiagnosis);
    }

    public String getDiscussion() {
        return (String)this.getValue(TCQueryFilterKey.Discussion);
    }

    public void setDiscussion(String discussion) {
        this.putValue(TCQueryFilterKey.Discussion, discussion);
    }

    public String getFinding() {
        try {
            return (String)this.getValue(TCQueryFilterKey.Finding);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'finding' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setFinding(String finding) {
        this.putValue(TCQueryFilterKey.Finding, finding);
    }

    public String getHistory() {
        return (String)this.getValue(TCQueryFilterKey.History);
    }

    public void setHistory(String history) {
        this.putValue(TCQueryFilterKey.History, history);
    }

    public String getKeyword() {
        try {
            return (String)this.getValue(TCQueryFilterKey.Keyword);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'keyword' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setKeyword(String keyword) {
        this.putValue(TCQueryFilterKey.Keyword, keyword);
    }

    public TCQueryFilterValue.Level getLevel() {
        return (TCQueryFilterValue.Level)this.getValue(TCQueryFilterKey.Level);
    }

    public void setLevel(TCQueryFilterValue.Level level) {
        this.putValue(TCQueryFilterKey.Level, level != null ? TCQueryFilterValue.create(level) : null);
    }

    public String getOrganSystem() {
        try {
            return (String)this.getValue(TCQueryFilterKey.OrganSystem);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'organ-system' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setOrganSystem(String organSystem) {
        this.putValue(TCQueryFilterKey.OrganSystem, organSystem);
    }

    public String getPathology() {
        try {
            return (String)this.getValue(TCQueryFilterKey.Pathology);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'pathology' is not of type String. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setPathology(String pathology) {
        this.putValue(TCQueryFilterKey.Pathology, pathology);
    }

    public TCQueryFilterValue.PatientSex getPatientSex() {
        return (TCQueryFilterValue.PatientSex)this.getValue(TCQueryFilterKey.PatientSex);
    }

    public void setPatientSex(TCQueryFilterValue.PatientSex patientSex) {
        this.putValue(TCQueryFilterKey.PatientSex, patientSex != null ? TCQueryFilterValue.create(patientSex) : null);
    }

    public String getPatientSpecies() {
        return (String)this.getValue(TCQueryFilterKey.PatientSpecies);
    }

    public void setPatientSpecies(String patientSpecies) {
        this.putValue(TCQueryFilterKey.PatientSpecies, patientSpecies);
    }

    public String getBibliographicReference() {
        return (String)this.getValue(TCQueryFilterKey.BibliographicReference);
    }

    public void setBibliographicReference(String bibliographicReference) {
        this.putValue(TCQueryFilterKey.BibliographicReference, bibliographicReference);
    }

    public String getTitle() {
        return (String)this.getValue(TCQueryFilterKey.Title);
    }

    public void setTitle(String title) {
        this.putValue(TCQueryFilterKey.Title, title);
    }

    public Code getAnatomyCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.Anatomy);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'anatomy' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setAnatomyCode(Code anatomyCode) {
        this.putValue(TCQueryFilterKey.Anatomy, anatomyCode != null ? TCQueryFilterValue.create(anatomyCode) : null);
    }

    public Code getDiagnosisCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.Diagnosis);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'diagnosis' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setDiagnosisCode(Code diagnosisCode) {
        this.putValue(TCQueryFilterKey.Diagnosis, diagnosisCode != null ? TCQueryFilterValue.create(diagnosisCode) : null);
    }

    public Code getDiffDiagnosisCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.DifferentialDiagnosis);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'diff-diagnosis' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setDiffDiagnosisCode(Code diffDiagnosisCode) {
        this.putValue(TCQueryFilterKey.DifferentialDiagnosis, diffDiagnosisCode != null ? TCQueryFilterValue.create(diffDiagnosisCode) : null);
    }

    public Code getFindingCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.Finding);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'finding' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setFindingCode(Code findingCode) {
        this.putValue(TCQueryFilterKey.Finding, findingCode != null ? TCQueryFilterValue.create(findingCode) : null);
    }

    public Code getKeywordCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.Keyword);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'keyword' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setKeywordCode(Code keywordCode) {
        this.putValue(TCQueryFilterKey.Keyword, keywordCode != null ? TCQueryFilterValue.create(keywordCode) : null);
    }

    public Code getOrganSystemCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.OrganSystem);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'organ-system' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setOrganSystemCode(Code organSystemCode) {
        this.putValue(TCQueryFilterKey.OrganSystem, organSystemCode != null ? TCQueryFilterValue.create(organSystemCode) : null);
    }

    public Code getPathologyCode() {
        try {
            return (Code)this.getValue(TCQueryFilterKey.Pathology);
        }
        catch (ClassCastException e) {
            log.warn("TC property 'pathology' not of type Code. Returning null...", (Throwable)e);
            return null;
        }
    }

    public void setPathologyCode(Code pathologyCode) {
        this.putValue(TCQueryFilterKey.Pathology, pathologyCode != null ? TCQueryFilterValue.create(pathologyCode) : null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TC search for ");
        if (this.values != null && !this.values.isEmpty()) {
            boolean first = true;
            sb.append(this.values.size() + " attributes (");
            for (Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>> me : this.values.entrySet()) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                sb.append(me.getKey().name());
                sb.append("=");
                sb.append("'" + me.getValue() + "'");
            }
            sb.append(")");
        } else {
            sb.append("0 attributes");
        }
        return sb.toString();
    }

    public Object getValue(TCQueryFilterKey key) {
        TCQueryFilterValue<?> value = this.values != null ? this.values.get((Object)key) : null;
        return value != null ? value.getValue() : null;
    }

    private void putValue(TCQueryFilterKey key, String value) {
        this.putValue(key, value != null && value.length() > 0 ? TCQueryFilterValue.create(value) : null);
    }

    private void putValue(TCQueryFilterKey key, TCQueryFilterValue<?> value) {
        if (value == null) {
            if (this.values != null) {
                this.values.remove((Object)key);
                if (this.values.isEmpty()) {
                    this.values = null;
                }
            }
        } else {
            if (this.values == null) {
                this.values = new HashMap(3);
            }
            this.values.put(key, value);
        }
    }
}

