/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.tc;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4chee.archive.entity.File;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.web.dao.tc.TCQueryFilter;
import org.dcm4chee.web.dao.tc.TCQueryFilterKey;
import org.dcm4chee.web.dao.tc.TCQueryFilterValue;
import org.dcm4chee.web.dao.tc.TCQueryLocal;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.jboss.annotation.ejb.LocalBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/TCListBean/local")
public class TCQueryBean
implements TCQueryLocal {
    private static final Logger log = LoggerFactory.getLogger(TCQueryBean.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public int countMatchingInstances(TCQueryFilter filter, List<String> roles, List<String> restrictedSourceAETs) {
        if (roles != null && roles.isEmpty()) {
            return 0;
        }
        boolean doStudyPermissionCheck = roles != null;
        boolean doSourceAETCheck = restrictedSourceAETs != null && !restrictedSourceAETs.isEmpty();
        StringBuilder sb = new StringBuilder(64);
        sb.append(" Select COUNT(*) FROM Instance instance");
        if (doStudyPermissionCheck || doSourceAETCheck) {
            sb.append(" LEFT JOIN FETCH instance.series series");
            if (doStudyPermissionCheck) {
                sb.append(" LEFT JOIN FETCH series.study s");
            }
        }
        sb.append(" LEFT JOIN FETCH instance.conceptNameCode sr_code");
        sb.append(" WHERE (instance.sopClassUID = '1.2.840.10008.5.1.4.1.1.88.11')");
        sb.append(" AND (sr_code.codeValue = 'TCE006')");
        sb.append(" AND (sr_code.codingSchemeDesignator = 'IHERADTF')");
        if (doSourceAETCheck) {
            sb.append(" AND (series.sourceAET IN (");
            for (int i = 0; i < restrictedSourceAETs.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(restrictedSourceAETs.get(i)).append("'");
            }
            sb.append("))");
        }
        Set<Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>>> entries = filter.getEntries();
        HashSet<TCQueryFilterValue.QueryParam[]> paramSets = null;
        if (entries != null) {
            for (Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>> e : entries) {
                sb.append(" AND (");
                TCQueryFilterValue.QueryParam[] params = e.getValue().appendSQLWhereConstraint(e.getKey(), sb);
                if (params != null) {
                    if (paramSets == null) {
                        paramSets = new HashSet<TCQueryFilterValue.QueryParam[]>();
                    }
                    paramSets.add(params);
                }
                sb.append(")");
            }
        }
        if (doStudyPermissionCheck) {
            QueryUtil.appendDicomSecurityFilter(sb);
        }
        Query query = this.em.createQuery(sb.toString());
        if (doStudyPermissionCheck) {
            query.setParameter("roles", roles);
        }
        if (paramSets != null) {
            for (TCQueryFilterValue.QueryParam[] paramSet : paramSets) {
                if (paramSet == null) continue;
                for (TCQueryFilterValue.QueryParam param : paramSet) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
        }
        return ((Number)query.getSingleResult()).intValue();
    }

    @Override
    public List<Instance> findMatchingInstances(TCQueryFilter filter, List<String> roles, List<String> restrictedSourceAETs) {
        if (roles != null && roles.isEmpty()) {
            return Collections.emptyList();
        }
        boolean doStudyPermissionCheck = roles != null;
        boolean doSourceAETCheck = restrictedSourceAETs != null && !restrictedSourceAETs.isEmpty();
        StringBuilder sb = new StringBuilder(64);
        sb.append(" FROM Instance instance");
        if (doStudyPermissionCheck || doSourceAETCheck) {
            sb.append(" LEFT JOIN FETCH instance.series series");
            if (doStudyPermissionCheck) {
                sb.append(" LEFT JOIN FETCH series.study s");
            }
        }
        sb.append(" LEFT JOIN FETCH instance.conceptNameCode sr_code");
        sb.append(" LEFT JOIN FETCH instance.media");
        sb.append(" WHERE (instance.sopClassUID = '1.2.840.10008.5.1.4.1.1.88.11')");
        sb.append(" AND (sr_code.codeValue = 'TCE006')");
        sb.append(" AND (sr_code.codingSchemeDesignator = 'IHERADTF')");
        if (doSourceAETCheck) {
            sb.append(" AND (series.sourceAET IN (");
            for (int i = 0; i < restrictedSourceAETs.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("'").append(restrictedSourceAETs.get(i)).append("'");
            }
            sb.append("))");
        }
        Set<Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>>> entries = filter.getEntries();
        HashSet<TCQueryFilterValue.QueryParam[]> paramSets = null;
        if (entries != null) {
            for (Map.Entry<TCQueryFilterKey, TCQueryFilterValue<?>> e : entries) {
                sb.append(" AND (");
                TCQueryFilterValue.QueryParam[] params = e.getValue().appendSQLWhereConstraint(e.getKey(), sb);
                if (params != null) {
                    if (paramSets == null) {
                        paramSets = new HashSet<TCQueryFilterValue.QueryParam[]>();
                    }
                    paramSets.add(params);
                }
                sb.append(")");
            }
        }
        if (doStudyPermissionCheck) {
            QueryUtil.appendDicomSecurityFilter(sb);
        }
        Query query = this.em.createQuery(sb.toString());
        if (doStudyPermissionCheck) {
            query.setParameter("roles", roles);
        }
        if (paramSets != null) {
            for (TCQueryFilterValue.QueryParam[] paramSet : paramSets) {
                if (paramSet == null) continue;
                for (TCQueryFilterValue.QueryParam param : paramSet) {
                    query.setParameter(param.getKey(), param.getValue());
                }
            }
        }
        log.info("Executing teaching-file query: " + query.toString());
        log.info("Restricted to aets: " + restrictedSourceAETs);
        List instances = query.getResultList();
        if (instances != null) {
            for (Instance instance : instances) {
                instance.getSeries().getSeriesInstanceUID();
                instance.getSeries().getStudy().getStudyInstanceUID();
                instance.getSeries().getStudy().getPatient().getPatientID();
                List files = instance.getFiles();
                if (files == null) continue;
                for (File file : files) {
                    file.getFilePath();
                    file.getFileSystem().getDirectoryPath();
                }
            }
            log.info(instances.size() + " matching teaching-files found!");
        }
        return instances;
    }
}

