/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.folder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import net.sf.json.JSONObject;
import org.dcm4chee.archive.entity.StudyPermission;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.web.dao.folder.StudyPermissionsLocal;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.system.server.ServerConfigLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/StudyPermissionsBean/local")
public class StudyPermissionsBean
implements StudyPermissionsLocal {
    private static Logger log = LoggerFactory.getLogger(StudyPermissionsBean.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;
    private File dicomRolesFile;

    @PostConstruct
    private void config() {
        if (this.dicomRolesFile == null) {
            this.dicomRolesFile = new File(System.getProperty("dcm4chee-web3.cfg.path", "conf/dcm4chee-web3") + "roles.json");
            if (!this.dicomRolesFile.isAbsolute()) {
                this.dicomRolesFile = new File(ServerConfigLocator.locate().getServerHomeDir(), this.dicomRolesFile.getPath());
            }
            if (log.isDebugEnabled()) {
                log.debug("mappingFile:" + this.dicomRolesFile);
            }
            if (!this.dicomRolesFile.exists()) {
                try {
                    if (this.dicomRolesFile.getParentFile().mkdirs()) {
                        log.info("M-WRITE dir:" + this.dicomRolesFile.getParent());
                    }
                    this.dicomRolesFile.createNewFile();
                }
                catch (IOException e) {
                    log.error("Roles file doesn't exist and can't be created!", (Throwable)e);
                }
            }
        }
    }

    @Override
    public List<StudyPermission> getStudyPermissions(String studyInstanceUID) {
        return this.em.createQuery("SELECT sp FROM StudyPermission sp WHERE sp.studyInstanceUID = :studyInstanceUID").setParameter("studyInstanceUID", (Object)studyInstanceUID).getResultList();
    }

    @Override
    public List<StudyPermission> getStudyPermissionsForPatient(long pk) {
        return this.em.createQuery("SELECT sp FROM StudyPermission sp, Study s WHERE sp.studyInstanceUID = s.studyInstanceUID AND s.patientFk = :pk ORDER BY sp.role, sp.action").setParameter("pk", (Object)pk).getResultList();
    }

    @Override
    public void grant(StudyPermission studyPermission) {
        this.em.persist((Object)studyPermission);
    }

    @Override
    public void revoke(long pk) {
        this.em.createQuery("DELETE FROM StudyPermission sp WHERE sp.pk = :pk").setParameter("pk", (Object)pk).executeUpdate();
    }

    @Override
    public List<String> grantForPatient(long pk, String action, String role) {
        List suids = this.em.createQuery("SELECT s.studyInstanceUID FROM Study s WHERE s.patientFk = :pk AND s.studyInstanceUID NOT IN(SELECT sp.studyInstanceUID FROM StudyPermission sp WHERE sp.action = :action AND sp.role = :role)").setParameter("pk", (Object)pk).setParameter("action", (Object)action).setParameter("role", (Object)role).getResultList();
        for (String studyInstanceUID : suids) {
            StudyPermission sp = new StudyPermission();
            sp.setAction(action);
            sp.setRole(role);
            sp.setStudyInstanceUID(studyInstanceUID);
            this.em.persist((Object)sp);
        }
        return suids;
    }

    @Override
    public List<String> revokeForPatient(long pk, String action, String role) {
        List suids = this.em.createQuery("SELECT s.studyInstanceUID FROM Study s WHERE s.patientFk = :pk AND s.studyInstanceUID NOT IN(SELECT sp.studyInstanceUID FROM StudyPermission sp WHERE sp.action = :action AND sp.role = :role)").setParameter("pk", (Object)pk).setParameter("action", (Object)action).setParameter("role", (Object)role).getResultList();
        this.em.createQuery("DELETE FROM StudyPermission sp WHERE sp.studyInstanceUID IN(SELECT s.studyInstanceUID FROM Study s WHERE s.patientFk = :pk) AND sp.action = :action AND sp.role = :role").setParameter("pk", (Object)pk).setParameter("action", (Object)action).setParameter("role", (Object)role).executeUpdate();
        return suids;
    }

    @Override
    public long countStudiesOfPatient(long pk) {
        return (Long)this.em.createQuery("SELECT COUNT(s) FROM Patient p, IN(p.studies) s WHERE p.pk = :pk").setParameter("pk", (Object)pk).getSingleResult();
    }

    @Override
    public List<String> getAllDicomRolenames() {
        ArrayList<String> dicomRolenames = new ArrayList<String>();
        for (Role dicomRole : this.getAllDicomRoles()) {
            dicomRolenames.add(dicomRole.getRolename());
        }
        return dicomRolenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Role> getAllDicomRoles() {
        ArrayList<Role> arrayList;
        BufferedReader reader = null;
        try {
            String line;
            ArrayList<Role> roleList = new ArrayList<Role>();
            reader = new BufferedReader(new FileReader(this.dicomRolesFile));
            while ((line = reader.readLine()) != null) {
                Role role = (Role)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), Role.class);
                if (!role.isDicomRole()) continue;
                roleList.add(role);
            }
            Collections.sort(roleList);
            arrayList = roleList;
            this.close(reader, "dicom roles file reader");
        }
        catch (Exception e) {
            List<Role> list;
            try {
                log.error("Can't get dicom roles from roles file!", (Throwable)e);
                list = null;
                this.close(reader, "dicom roles file reader");
            }
            catch (Throwable throwable) {
                this.close(reader, "dicom roles file reader");
                throw throwable;
            }
            return list;
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDicomRoles() {
        List<String> dicomRolenames = this.getAllDicomRolenames();
        List newRoles = dicomRolenames.size() == 0 ? this.em.createQuery("SELECT DISTINCT sp.role FROM StudyPermission sp").getResultList() : this.em.createQuery("SELECT DISTINCT sp.role FROM StudyPermission sp WHERE sp.role NOT IN(:dicomRoles)").setParameter("dicomRoles", dicomRolenames).getResultList();
        log.info("dicomRolenames:" + dicomRolenames);
        log.info("newRoles:" + newRoles);
        ArrayList<Role> roles = new ArrayList<Role>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.dicomRolesFile));
            while ((line = reader.readLine()) != null) {
                Role role = (Role)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), Role.class);
                if (newRoles.contains(role.getRolename())) {
                    role.setDicomRole(true);
                    newRoles.remove(role.getRolename());
                }
                roles.add(role);
            }
            if (this.close(reader, "roles file reader")) {
                reader = null;
            }
            log.info("newRoles to add:" + newRoles);
            for (String rolename : newRoles) {
                Role role = new Role(rolename);
                role.setDicomRole(true);
                roles.add(role);
            }
            Collections.sort(roles);
            log.info("save Roles:" + roles);
            this.save(roles);
            this.close(reader, "roles file reader in finally");
        }
        catch (Exception e) {
            try {
                log.error("Can't get roles from roles file!", (Throwable)e);
                this.close(reader, "roles file reader in finally");
            }
            catch (Throwable throwable) {
                this.close(reader, "roles file reader in finally");
                throw throwable;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDicomRole(String rolename) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.dicomRolesFile, true));
            Role role = new Role(rolename);
            role.setDicomRole(true);
            JSONObject jsonObject = JSONObject.fromObject((Object)role);
            writer.write(jsonObject.toString());
            writer.newLine();
            this.close(writer, "roles file reader");
        }
        catch (IOException e) {
            try {
                log.error("Can't add dicom role to roles file!", (Throwable)e);
                this.close(writer, "roles file reader");
            }
            catch (Throwable throwable) {
                this.close(writer, "roles file reader");
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDicomRole(Role role) {
        ArrayList<Role> roles = new ArrayList<Role>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.dicomRolesFile));
            while ((line = reader.readLine()) != null) {
                Role currentRole = (Role)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)line), Role.class);
                if (currentRole.equals((Object)role)) {
                    currentRole.setDicomRole(false);
                }
                roles.add(currentRole);
            }
            this.close(reader, "roles file reader");
        }
        catch (Exception e) {
            try {
                log.error("Can't get roles from roles file!", (Throwable)e);
                this.close(reader, "roles file reader");
            }
            catch (Throwable throwable) {
                this.close(reader, "roles file reader");
                throw throwable;
            }
            return;
        }
        this.save(roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(List<Role> roles) {
        BufferedWriter writer = null;
        try {
            File tmpFile = File.createTempFile(this.dicomRolesFile.getName(), null, this.dicomRolesFile.getParentFile());
            log.info("tmpFile:" + tmpFile);
            writer = new BufferedWriter(new FileWriter(tmpFile, true));
            int len = roles.size();
            for (int i = 0; i < len; ++i) {
                JSONObject jsonObject = JSONObject.fromObject((Object)roles.get(i));
                writer.write(jsonObject.toString());
                writer.newLine();
            }
            if (this.close(writer, "Temporary roles file")) {
                writer = null;
            }
            this.dicomRolesFile.delete();
            tmpFile.renameTo(this.dicomRolesFile);
            log.info("dicomRolesFile:" + this.dicomRolesFile);
            this.close(writer, "Temporary roles file (in finally block)");
        }
        catch (IOException e) {
            log.error("Can't save roles in roles file!", (Throwable)e);
        }
        finally {
            this.close(writer, "Temporary roles file (in finally block)");
        }
    }

    private boolean close(Closeable toClose, String desc) {
        log.debug("Closing ", (Object)desc);
        if (toClose != null) {
            try {
                toClose.close();
                return true;
            }
            catch (IOException ignore) {
                log.warn("Error closing : " + desc, (Throwable)ignore);
            }
        }
        return false;
    }
}

