/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.folder;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DateRange;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.dao.util.QueryUtil;

public class StudyListFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String patientName;
    private String patientID;
    private String issuerOfPatientID;
    private boolean extendedQuery;
    private Date birthDateMin;
    private Date birthDateMax;
    private String accessionNumber;
    private Date studyDateMin;
    private Date studyDateMax;
    private String studyInstanceUID;
    private String modality;
    private String sourceAET;
    private String seriesInstanceUID;
    private boolean patientQuery;
    private boolean latestStudiesFirst;
    private boolean ppsWithoutMwl;
    private boolean withoutPps;
    private boolean exactModalitiesInStudy;
    private boolean exactSeriesIuid;
    private int autoExpandLevel = -1;
    private boolean fuzzyPN;
    private int autoWildcard = 0;
    private boolean isStudyIuidQuery;
    private boolean isSeriesIuidQuery;

    public StudyListFilter(String forUsername) {
        this.clear();
    }

    public void clear() {
        this.seriesInstanceUID = null;
        this.sourceAET = null;
        this.modality = null;
        this.studyInstanceUID = null;
        this.accessionNumber = null;
        this.issuerOfPatientID = null;
        this.patientID = null;
        this.patientName = null;
        this.studyDateMax = null;
        this.studyDateMin = null;
        this.birthDateMax = null;
        this.birthDateMin = null;
        this.patientQuery = false;
        this.latestStudiesFirst = false;
        this.ppsWithoutMwl = false;
        this.withoutPps = false;
        this.exactModalitiesInStudy = false;
        this.exactSeriesIuid = false;
        this.fuzzyPN = false;
        this.isSeriesIuidQuery = false;
        this.isStudyIuidQuery = false;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public void setPatientName(String patientName) {
        this.patientName = patientName;
    }

    public boolean isFuzzyPNEnabled() {
        return AttributeFilter.isSoundexEnabled();
    }

    public boolean isFuzzyPN() {
        return this.fuzzyPN;
    }

    public void setFuzzyPN(boolean fuzzyPN) {
        this.fuzzyPN = fuzzyPN;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public void setPatientID(String patientID) {
        this.patientID = patientID;
    }

    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    public void setIssuerOfPatientID(String issuerOfPatientID) {
        this.issuerOfPatientID = issuerOfPatientID;
    }

    public boolean isExtendedQuery() {
        return this.extendedQuery;
    }

    public void setExtendedQuery(boolean extendedQuery) {
        this.extendedQuery = extendedQuery;
    }

    public Date getBirthDateMin() {
        return this.birthDateMin;
    }

    public void setBirthDateMin(Date birthdateMin) {
        this.birthDateMin = birthdateMin;
    }

    public Date getBirthDateMax() {
        return this.birthDateMax;
    }

    public void setBirthDateMax(Date birthdateMax) {
        this.birthDateMax = birthdateMax;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public void setAccessionNumber(String accessionNumber) {
        this.accessionNumber = accessionNumber;
    }

    public boolean isWithoutPps() {
        return this.withoutPps;
    }

    public void setWithoutPps(boolean withoutPps) {
        this.withoutPps = withoutPps;
    }

    public boolean isPpsWithoutMwl() {
        return this.ppsWithoutMwl;
    }

    public void setPpsWithoutMwl(boolean ppsWithoutMwl) {
        this.ppsWithoutMwl = ppsWithoutMwl;
    }

    public Date getStudyDateMin() {
        return this.studyDateMin;
    }

    public void setStudyDateMin(Date studyDate) {
        this.studyDateMin = studyDate;
    }

    public Date getStudyDateMax() {
        return this.studyDateMax;
    }

    public void setStudyDateMax(Date studyDate) {
        this.studyDateMax = studyDate;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public void setStudyInstanceUID(String studyInstanceUID) {
        this.studyInstanceUID = studyInstanceUID;
    }

    public String getModality() {
        return this.modality;
    }

    public void setModality(String modality) {
        this.modality = modality;
    }

    public boolean isExactModalitiesInStudy() {
        return this.exactModalitiesInStudy;
    }

    public void setExactModalitiesInStudy(boolean exactModalitiesInStudy) {
        this.exactModalitiesInStudy = exactModalitiesInStudy;
    }

    public boolean isExactSeriesIuid() {
        return this.exactSeriesIuid;
    }

    public void setExactSeriesIuid(boolean exactSeriesIuid) {
        this.exactSeriesIuid = exactSeriesIuid;
    }

    public String getSourceAET() {
        return this.sourceAET;
    }

    public void setSourceAET(String sourceAET) {
        this.sourceAET = sourceAET;
    }

    public String[] getSourceAETs() {
        HashSet aetStringSet = new HashSet();
        if (this.sourceAET != null) {
            if (this.sourceAET.startsWith("(") && this.sourceAET.endsWith(")")) {
                String groupName = this.sourceAET.substring(1, this.sourceAET.length() - 1);
                for (AETGroup aetGroup : ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getAllAETGroups()) {
                    if (!aetGroup.getGroupname().equals(groupName)) continue;
                    aetStringSet.addAll(aetGroup.getAets());
                }
            } else {
                return new String[]{this.sourceAET};
            }
        }
        return aetStringSet.toArray(new String[aetStringSet.size()]);
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public void setSeriesInstanceUID(String seriesInstanceUID) {
        this.seriesInstanceUID = seriesInstanceUID;
    }

    public boolean isPatientQuery() {
        return this.patientQuery;
    }

    public void setPatientQuery(boolean patQuery) {
        this.patientQuery = patQuery;
    }

    public boolean isLatestStudiesFirst() {
        return this.latestStudiesFirst;
    }

    public void setLatestStudiesFirst(boolean latestStudiesFirst) {
        this.latestStudiesFirst = latestStudiesFirst;
    }

    public void setAutoExpandLevel(int level) {
        this.autoExpandLevel = level;
    }

    public int getAutoExpandLevel() {
        return this.autoExpandLevel;
    }

    public boolean isAutoWildcard() {
        return this.autoWildcard > 1;
    }

    public boolean isPNAutoWildcard() {
        return this.autoWildcard > 0;
    }

    public void setAutoWildcard(int autoWildcard) {
        this.autoWildcard = autoWildcard;
    }

    public boolean isStudyIuidQuery() {
        return this.isStudyIuidQuery;
    }

    public void setStudyIuidQuery(boolean b) {
        this.isStudyIuidQuery = b;
    }

    public boolean isSeriesIuidQuery() {
        return this.isSeriesIuidQuery;
    }

    public void setSeriesIuidQuery(boolean b) {
        this.isSeriesIuidQuery = b;
    }

    public DicomObject getQueryDicomObject() {
        BasicDicomObject obj = new BasicDicomObject();
        if (this.patientQuery) {
            obj.putString(524370, VR.CS, "PATIENT");
            this.addPatientAttrs((DicomObject)obj);
        } else if (this.extendedQuery && this.isSeriesIuidQuery && !this.isStudyIuidQuery) {
            obj.putString(524370, VR.CS, "SERIES");
            obj.putString(0x20000E, VR.UI, this.seriesInstanceUID);
        } else if (this.extendedQuery && this.isStudyIuidQuery) {
            obj.putString(524370, VR.CS, "STUDY");
            obj.putString(0x20000D, VR.UI, this.studyInstanceUID);
        } else {
            obj.putString(524370, VR.CS, "STUDY");
            this.addPatientAttrs((DicomObject)obj);
            obj.putString(524368, VR.SH, QueryUtil.checkAutoWildcard(this.accessionNumber, this.isAutoWildcard()));
            obj.putDateRange(524320, VR.DA, new DateRange(this.studyDateMin, this.studyDateMax));
            obj.putDateRange(524336, VR.TM, new DateRange(this.studyDateMin, this.studyDateMax));
            obj.putString(524384, VR.CS, this.modality);
        }
        return obj;
    }

    private void addPatientAttrs(DicomObject obj) {
        obj.putString(0x100010, VR.PN, QueryUtil.checkAutoWildcard(this.patientName, this.isPNAutoWildcard()));
        obj.putString(0x100020, VR.LO, QueryUtil.checkAutoWildcard(this.patientID, this.isAutoWildcard()));
        obj.putString(0x100021, VR.LO, QueryUtil.checkAutoWildcard(this.issuerOfPatientID, this.isAutoWildcard()));
        if (this.extendedQuery) {
            obj.putDateRange(0x100030, VR.DA, new DateRange(this.birthDateMin, this.birthDateMax));
        }
    }
}

