/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.folder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.common.StorageStatus;
import org.dcm4chee.archive.entity.File;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.archive.entity.StudyPermission;
import org.dcm4chee.web.dao.folder.StudyListFilter;
import org.dcm4chee.web.dao.folder.StudyListLocal;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.jboss.annotation.ejb.LocalBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/StudyListBean/local")
public class StudyListBean
implements StudyListLocal {
    private static Comparator<Instance> instanceComparator = new Comparator<Instance>(){

        @Override
        public int compare(Instance o1, Instance o2) {
            String in1 = o1.getInstanceNumber();
            String in2 = o2.getInstanceNumber();
            return QueryUtil.compareIntegerStringAndPk(o1.getPk(), o2.getPk(), in1, in2);
        }
    };
    private static Comparator<Series> seriesComparator = new Comparator<Series>(){

        @Override
        public int compare(Series o1, Series o2) {
            String in1 = o1.getSeriesNumber();
            String in2 = o2.getSeriesNumber();
            return QueryUtil.compareIntegerStringAndPk(o1.getPk(), o2.getPk(), in1, in2);
        }
    };
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public int count(StudyListFilter filter, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return 0;
        }
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT COUNT(*)");
        StudyListBean.appendFromClause(ql, filter);
        this.appendWhereClause(ql, filter, roles);
        Query query = this.em.createQuery(ql.toString());
        StudyListBean.setQueryParameters(query, filter, roles);
        return ((Number)query.getSingleResult()).intValue();
    }

    @Override
    public List<Patient> findPatients(StudyListFilter filter, int max, int index, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return new ArrayList<Patient>();
        }
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT p");
        if (!filter.isPatientQuery()) {
            ql.append(", s");
        }
        StudyListBean.appendFromClause(ql, filter);
        this.appendWhereClause(ql, filter, roles);
        String studyDT = filter.isPatientQuery() ? null : (filter.isLatestStudiesFirst() ? "s.studyDateTime DESC" : "s.studyDateTime");
        QueryUtil.appendOrderBy(ql, new String[]{"p.patientName", studyDT});
        Query query = this.em.createQuery(ql.toString());
        StudyListBean.setQueryParameters(query, filter, roles);
        if (filter.isPatientQuery()) {
            return query.setMaxResults(max).setFirstResult(index).getResultList();
        }
        List result = query.setMaxResults(max).setFirstResult(index).getResultList();
        ArrayList<Patient> patientList = new ArrayList<Patient>();
        Patient patient = null;
        for (Object[] element : result) {
            if (!patientList.contains((Patient)element[0])) {
                patient = (Patient)element[0];
                patient.setStudies(new LinkedHashSet());
                patientList.add(patient);
            }
            patient.getStudies().add((Study)element[1]);
        }
        return patientList;
    }

    private static void appendFromClause(StringBuilder ql, StudyListFilter filter) {
        ql.append(" FROM Patient p");
        if (!filter.isPatientQuery()) {
            ql.append(" INNER JOIN p.studies s");
        }
    }

    private void appendWhereClause(StringBuilder ql, StudyListFilter filter, List<String> roles) {
        ql.append(" WHERE p.mergedWith IS NULL");
        if (filter.isPatientQuery()) {
            StudyListBean.appendPatFilter(ql, filter);
        } else {
            if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
                ql.append(" AND s.studyInstanceUID = :studyInstanceUID");
            } else if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getSeriesInstanceUID())) {
                QueryUtil.appendSeriesInstanceUIDFilter(ql, filter.getSeriesInstanceUID());
            } else {
                StudyListBean.appendPatFilter(ql, filter);
                QueryUtil.appendAccessionNumberFilter(ql, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
                QueryUtil.appendPpsWithoutMwlFilter(ql, filter.isWithoutPps(), filter.isPpsWithoutMwl());
                QueryUtil.appendStudyDateMinFilter(ql, filter.getStudyDateMin());
                QueryUtil.appendStudyDateMaxFilter(ql, filter.getStudyDateMax());
                if (filter.isExactModalitiesInStudy()) {
                    QueryUtil.appendModalitiesInStudyExactFilter(ql, filter.getModality());
                } else {
                    QueryUtil.appendModalityFilter(ql, filter.getModality());
                }
                QueryUtil.appendSourceAETFilter(ql, filter.getSourceAETs());
            }
            if (roles != null && !filter.isPatientQuery()) {
                QueryUtil.appendDicomSecurityFilter(ql);
            }
        }
    }

    private static void appendPatFilter(StringBuilder ql, StudyListFilter filter) {
        if (filter.isFuzzyPN()) {
            QueryUtil.appendPatientNameFuzzyFilter(ql, filter.getPatientName());
        } else {
            QueryUtil.appendPatientNameFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
        }
        QueryUtil.appendPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
        QueryUtil.appendIssuerOfPatientIDFilter(ql, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
        if (filter.isExtendedQuery()) {
            QueryUtil.appendPatientBirthDateFilter(ql, filter.getBirthDateMin(), filter.getBirthDateMax());
        }
    }

    private static void setQueryParameters(Query query, StudyListFilter filter, List<String> roles) {
        if (filter.isPatientQuery()) {
            StudyListBean.setPatQueryParameters(query, filter);
        } else {
            if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getStudyInstanceUID())) {
                QueryUtil.setStudyInstanceUIDQueryParameter(query, filter.getStudyInstanceUID());
            } else if (filter.isExtendedQuery() && !QueryUtil.isUniversalMatch(filter.getSeriesInstanceUID())) {
                QueryUtil.setSeriesInstanceUIDQueryParameter(query, filter.getSeriesInstanceUID());
            } else {
                StudyListBean.setPatQueryParameters(query, filter);
                QueryUtil.setAccessionNumberQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getAccessionNumber(), filter.isAutoWildcard()));
                QueryUtil.setStudyDateMinQueryParameter(query, filter.getStudyDateMin());
                QueryUtil.setStudyDateMaxQueryParameter(query, filter.getStudyDateMax());
                QueryUtil.setModalityQueryParameter(query, filter.getModality());
                QueryUtil.setSourceAETQueryParameter(query, filter.getSourceAETs());
            }
            if (roles != null && !filter.isPatientQuery()) {
                query.setParameter("roles", roles);
            }
            if (!QueryUtil.isUniversalMatch(filter.getModality()) && filter.isExactModalitiesInStudy()) {
                query.setParameter("modality", (Object)filter.getModality());
            }
        }
    }

    private static void setPatQueryParameters(Query query, StudyListFilter filter) {
        if (filter.isFuzzyPN()) {
            QueryUtil.setPatientNameFuzzyQueryParameter(query, filter.getPatientName());
        } else {
            QueryUtil.setPatientNameQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientName(), filter.isPNAutoWildcard()));
        }
        QueryUtil.setPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getPatientID(), filter.isAutoWildcard()));
        QueryUtil.setIssuerOfPatientIDQueryParameter(query, QueryUtil.checkAutoWildcard(filter.getIssuerOfPatientID(), filter.isAutoWildcard()));
        if (filter.isExtendedQuery()) {
            QueryUtil.setPatientBirthDateQueryParameter(query, filter.getBirthDateMin(), filter.getBirthDateMax());
        }
    }

    @Override
    public int countStudiesOfPatient(long pk, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return 0;
        }
        return ((Number)this.getStudiesOfPatientQuery(true, pk, false, roles).getSingleResult()).intValue();
    }

    @Override
    public List<Study> findStudiesOfPatient(long pk, boolean latestStudyFirst, List<String> roles) {
        if (roles != null && roles.size() == 0) {
            return new ArrayList<Study>();
        }
        return this.getStudiesOfPatientQuery(false, pk, latestStudyFirst, roles).getResultList();
    }

    private Query getStudiesOfPatientQuery(boolean isCount, long pk, boolean latestStudyFirst, List<String> roles) {
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT " + (isCount ? "COUNT(s)" : "s") + " FROM Study s WHERE s.patient.pk=?1");
        if (roles != null) {
            QueryUtil.appendDicomSecurityFilter(ql);
        }
        if (!isCount) {
            ql.append(latestStudyFirst ? " ORDER BY s.studyDateTime DESC" : " ORDER BY s.studyDateTime");
        }
        Query query = this.em.createQuery(ql.toString());
        query.setParameter(1, (Object)pk);
        if (roles != null) {
            query.setParameter("roles", roles);
        }
        return query;
    }

    @Override
    public boolean isActionForAllStudiesOfPatientAllowed(long patPk, String action, List<String> roles) {
        if (roles == null) {
            return true;
        }
        if (roles.isEmpty()) {
            return false;
        }
        StringBuilder ql = new StringBuilder(64);
        ql.append("SELECT COUNT(s) FROM Study s WHERE s.patient.pk = ?1").append(" AND (s.studyInstanceUID NOT IN (SELECT sp.studyInstanceUID FROM StudyPermission sp WHERE sp.action = ?2 AND sp.role IN (:roles)))");
        Query query = this.em.createQuery(ql.toString());
        query.setParameter(1, (Object)patPk);
        query.setParameter(2, (Object)action);
        query.setParameter("roles", roles);
        return ((Number)query.getSingleResult()).intValue() == 0;
    }

    @Override
    public List<String> findStudyPermissionActions(String studyInstanceUID, List<String> roles) {
        if (roles == null) {
            return null;
        }
        return roles != null && roles.size() > 0 ? this.em.createQuery("SELECT DISTINCT sp.action FROM StudyPermission sp WHERE sp.studyInstanceUID = :studyInstanceUID AND role IN (:roles)").setParameter("studyInstanceUID", (Object)studyInstanceUID).setParameter("roles", roles).getResultList() : new ArrayList<String>();
    }

    @Override
    public List<Series> findSeriesOfStudy(long pk) {
        return this.sortSeries(this.em.createQuery("FROM Series s LEFT JOIN FETCH s.modalityPerformedProcedureStep WHERE s.study.pk=?1 ORDER BY s.seriesNumber, s.pk").setParameter(1, (Object)pk).getResultList());
    }

    @Override
    public int countSeriesOfStudy(long pk) {
        return ((Number)this.em.createQuery("SELECT COUNT(s) FROM Series s WHERE s.study.pk=?1").setParameter(1, (Object)pk).getSingleResult()).intValue();
    }

    @Override
    public Series findSeriesByIuid(String iuid) {
        Query q = this.em.createQuery("FROM Series s LEFT JOIN FETCH s.modalityPerformedProcedureStep WHERE s.seriesInstanceUID = :iuid");
        q.setParameter("iuid", (Object)iuid);
        return (Series)q.getSingleResult();
    }

    @Override
    public List<Series> findSeriesOfMpps(String uid) {
        return this.sortSeries(this.em.createQuery("FROM Series s WHERE s.performedProcedureStepInstanceUID=?1 ORDER BY s.pk").setParameter(1, (Object)uid).getResultList());
    }

    private List<Series> sortSeries(List<Series> l) {
        Collections.sort(l, seriesComparator);
        return l;
    }

    @Override
    public List<Instance> findInstancesOfSeries(long pk) {
        List l = this.em.createQuery("FROM Instance i LEFT JOIN FETCH i.media WHERE i.series.pk=?1 ORDER BY i.pk").setParameter(1, (Object)pk).getResultList();
        Collections.sort(l, instanceComparator);
        return l;
    }

    @Override
    public int countInstancesOfSeries(long pk) {
        return ((Number)this.em.createQuery("SELECT COUNT(i) FROM Instance i WHERE i.series.pk=?1").setParameter(1, (Object)pk).getSingleResult()).intValue();
    }

    @Override
    public List<File> findFilesOfInstance(long pk) {
        return this.em.createQuery("FROM File f JOIN FETCH f.fileSystem WHERE f.instance.pk=?1 ORDER BY f.pk").setParameter(1, (Object)pk).getResultList();
    }

    @Override
    public List<String> selectDistinctSourceAETs() {
        return this.em.createQuery("SELECT DISTINCT s.sourceAET FROM Series s WHERE s.sourceAET IS NOT NULL ORDER BY s.sourceAET").getResultList();
    }

    @Override
    public List<String> selectDistinctModalities() {
        return this.em.createQuery("SELECT DISTINCT s.modality FROM Series s WHERE s.modality IS NOT NULL ORDER BY s.modality").getResultList();
    }

    @Override
    public Patient getPatient(long pk) {
        return (Patient)this.em.find(Patient.class, (Object)pk);
    }

    @Override
    public Patient updatePatient(long pk, DicomObject attrs) {
        Patient patient = (Patient)this.em.find(Patient.class, (Object)pk);
        patient.setAttributes(attrs);
        return patient;
    }

    @Override
    public Study getStudy(long pk) {
        return (Study)this.em.find(Study.class, (Object)pk);
    }

    @Override
    public Study updateStudy(long pk, DicomObject attrs) {
        Study study = (Study)this.em.find(Study.class, (Object)pk);
        study.setAttributes(attrs);
        return study;
    }

    @Override
    public Study addStudy(long patPk, DicomObject attrs) {
        Patient pat = (Patient)this.em.find(Patient.class, (Object)patPk);
        Study study = new Study();
        study.setAttributes(attrs);
        study.setPatient(pat);
        study.setAvailability(Availability.ONLINE);
        this.em.persist((Object)study);
        return study;
    }

    @Override
    public void copyStudyPermissions(String srcStudyIuid, String destStudyIuid) {
        Query query = this.em.createQuery("SELECT sp FROM StudyPermission sp WHERE studyInstanceUID=?1");
        query.setParameter(1, (Object)srcStudyIuid);
        List l = query.getResultList();
        for (StudyPermission sp : l) {
            StudyPermission studyPermission = new StudyPermission();
            studyPermission.setAction(sp.getAction());
            studyPermission.setRole(sp.getRole());
            studyPermission.setStudyInstanceUID(destStudyIuid);
            this.em.persist((Object)studyPermission);
        }
    }

    @Override
    public Series getSeries(long pk) {
        return (Series)this.em.find(Series.class, (Object)pk);
    }

    @Override
    public Series updateSeries(long pk, DicomObject attrs) {
        Series series = (Series)this.em.find(Series.class, (Object)pk);
        series.setAttributes(attrs);
        return series;
    }

    @Override
    public Series addSeries(long studyPk, DicomObject attrs) {
        Study study = (Study)this.em.find(Study.class, (Object)studyPk);
        Series series = new Series();
        series.setAttributes(attrs);
        series.setStudy(study);
        series.setAvailability(Availability.ONLINE);
        series.setNumberOfSeriesRelatedInstances(0);
        series.setStorageStatus(StorageStatus.STORED);
        study.setNumberOfStudyRelatedSeries(study.getNumberOfStudyRelatedSeries() + 1);
        this.em.persist((Object)series);
        this.em.persist((Object)study);
        return series;
    }

    @Override
    public Instance getInstance(long pk) {
        return (Instance)this.em.find(Instance.class, (Object)pk);
    }

    @Override
    public Instance updateInstance(long pk, DicomObject attrs) {
        Instance inst = (Instance)this.em.find(Instance.class, (Object)pk);
        inst.setAttributes(attrs);
        return inst;
    }

    @Override
    public MPPS getMPPS(long pk) {
        return (MPPS)this.em.find(MPPS.class, (Object)pk);
    }

    @Override
    public MPPS updateMPPS(long pk, DicomObject attrs) {
        MPPS mpps = (MPPS)this.em.find(MPPS.class, (Object)pk);
        mpps.setAttributes(attrs);
        return mpps;
    }

    @Override
    public long countDownloadableInstances(String[] studyIuids, String[] seriesIuids, String[] sopIuids) {
        if (studyIuids == null && seriesIuids == null && sopIuids == null) {
            return 0L;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT count(i) FROM Instance i WHERE ");
        Object[] uids = this.appendUIDs(studyIuids, seriesIuids, sopIuids, sb);
        Query q = this.em.createQuery(sb.toString());
        QueryUtil.setParametersForIN(q, uids);
        return (Long)q.getSingleResult();
    }

    @Override
    public List<Instance> getDownloadableInstances(String[] studyIuids, String[] seriesIuids, String[] sopIuids) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT i FROM Instance i JOIN FETCH i.series s JOIN FETCH s.study st JOIN FETCH st.patient WHERE ");
        Object[] uids = this.appendUIDs(studyIuids, seriesIuids, sopIuids, sb);
        if (uids == null) {
            return null;
        }
        Query q = this.em.createQuery(sb.toString());
        QueryUtil.setParametersForIN(q, uids);
        List instances = q.getResultList();
        for (Instance instance : instances) {
            for (File file : instance.getFiles()) {
                file.getFileSystem().getDirectoryPath();
            }
        }
        return instances;
    }

    @Override
    public boolean hasStudyForeignPpsInfo(long studyPk) {
        return (Long)this.em.createQuery("SELECT count(s) FROM Series s WHERE s.study.pk=?1 AND s.performedProcedureStepInstanceUID IS NOT NULL AND s.modalityPerformedProcedureStep IS NULL").setParameter(1, (Object)studyPk).getSingleResult() > 0L;
    }

    private String[] appendUIDs(String[] studyIuids, String[] seriesIuids, String[] sopIuids, StringBuilder sb) {
        String[] uids;
        if (sopIuids != null) {
            uids = sopIuids;
            sb.append("i.sopInstanceUID");
        } else if (seriesIuids != null) {
            uids = seriesIuids;
            sb.append("i.series.seriesInstanceUID");
        } else if (studyIuids != null) {
            uids = studyIuids;
            sb.append("i.series.study.studyInstanceUID");
        } else {
            return null;
        }
        QueryUtil.appendIN(sb, uids.length);
        return uids;
    }
}

