/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.folder;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.MWLItem;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.web.dao.folder.MppsToMwlLinkLocal;
import org.dcm4chee.web.dao.util.CoercionUtil;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.dcm4chee.web.dao.vo.MppsToMwlLinkResult;
import org.jboss.annotation.ejb.LocalBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/MppsToMwlLinkBean/local")
public class MppsToMwlLinkBean
implements MppsToMwlLinkLocal {
    private static Logger log = LoggerFactory.getLogger(MppsToMwlLinkBean.class);
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public MppsToMwlLinkResult linkMppsToMwl(String mppsIUID, String rpId, String spsId, boolean updateMwlStatus, String modifyingSystem, String reason) {
        Query qMwl = this.em.createQuery("select object(m) from MWLItem m where requestedProcedureID = :rpId and scheduledProcedureStepID = :spsId");
        qMwl.setParameter("rpId", (Object)rpId).setParameter("spsId", (Object)spsId);
        MWLItem mwl = (MWLItem)qMwl.getSingleResult();
        Query qMpps = this.em.createQuery("select object(m) from MPPS m where sopInstanceUID = :mppsIUID");
        qMpps.setParameter("mppsIUID", (Object)mppsIUID);
        List mppss = qMpps.getResultList();
        return this.link(mppss, mwl, updateMwlStatus, modifyingSystem, reason);
    }

    @Override
    public MppsToMwlLinkResult linkMppsToMwl(long[] mppsPks, long mwlPk, boolean updateMwlStatus, String modifyingSystem, String reason) {
        Query qMwl = this.em.createQuery("select object(m) from MWLItem m where pk = :pk");
        qMwl.setParameter("pk", (Object)mwlPk);
        MWLItem mwl = (MWLItem)qMwl.getSingleResult();
        Query qMpps = QueryUtil.getQueryForPks(this.em, "select object(m) from MPPS m where pk ", mppsPks);
        List mppss = qMpps.getResultList();
        return this.link(mppss, mwl, updateMwlStatus, modifyingSystem, reason);
    }

    @Override
    public MppsToMwlLinkResult linkMppsToMwl(long[] mppsPks, DicomObject mwlAttrs, Patient mwlPat, String modifyingSystem, String reason) {
        Query qMpps = QueryUtil.getQueryForPks(this.em, "select object(m) from MPPS m where pk ", mppsPks);
        List mppss = qMpps.getResultList();
        MppsToMwlLinkResult result = new MppsToMwlLinkResult();
        MWLItem mwl = new MWLItem();
        mwl.setAttributes(mwlAttrs);
        mwl.setPatient(mwlPat);
        result.setMwl(mwl);
        for (MPPS mpps : mppss) {
            log.debug("link MPPS {} with MWL!", (Object)mpps);
            Patient mppsPat = mpps.getPatient();
            if (mppsPat.getPk() != mwlPat.getPk()) {
                log.warn("Patient of MPPS(" + mppsPat.getPatientID() + ") and MWL(" + mwlPat.getPatientID() + ") are different!");
                result.addStudyToMove(((Series)mpps.getSeries().iterator().next()).getStudy());
            }
            this.link(mpps, mwlAttrs, modifyingSystem, reason);
            result.addMppsAttributes(mpps);
        }
        return result;
    }

    private MppsToMwlLinkResult link(List<MPPS> mppss, MWLItem mwl, boolean updateMwlStatus, String modifyingSystem, String reason) {
        Patient mwlPat = mwl.getPatient();
        MppsToMwlLinkResult result = new MppsToMwlLinkResult();
        result.setMwl(mwl);
        DicomObject mwlAttrs = mwl.getAttributes();
        for (MPPS mpps : mppss) {
            Patient patMpps = mpps.getPatient();
            if (patMpps.getPk() != mwlPat.getPk()) {
                log.warn("Patient of MPPS(" + patMpps.getPatientID() + ") and MWL(" + mwlPat.getPatientName() + ") are different!");
                result.addStudyToMove(((Series)mpps.getSeries().iterator().next()).getStudy());
            }
            this.link(mpps, mwlAttrs, modifyingSystem, reason);
            result.addMppsAttributes(mpps);
        }
        if (updateMwlStatus) {
            mwlAttrs.get(0x400100).getDicomObject().putString(0x400020, VR.CS, "COMPLETED");
            mwl.setAttributes(mwlAttrs);
            this.em.merge((Object)mwl);
        }
        return result;
    }

    private void link(MPPS mpps, DicomObject mwlAttrs, String modifyingSystem, String reason) {
        DicomObject ssa;
        DicomObject mppsAttrs = mpps.getAttributes();
        log.debug("MPPS attrs:{}", (Object)mpps);
        log.debug("MWL attrs:{}", (Object)mwlAttrs);
        String rpid = mwlAttrs.getString(0x401001);
        DicomElement spsSq = mwlAttrs.get(0x400100);
        String spsid = spsSq.getDicomObject().getString(0x400009);
        String accNo = mwlAttrs.getString(524368);
        DicomElement ssaSQ = mppsAttrs.get(4194928);
        BasicDicomObject origAttrs = new BasicDicomObject();
        mppsAttrs.subSet(new int[]{4194928}).copyTo((DicomObject)origAttrs);
        this.updateOriginalAttributeSequence(mppsAttrs, (DicomObject)origAttrs, modifyingSystem, reason);
        String studyIUID = null;
        boolean spsNotInList = true;
        boolean invalidSSAItem0 = false;
        int len = ssaSQ.countItems();
        for (int i = 0; i < len; ++i) {
            String ssaSpsID;
            ssa = ssaSQ.getDicomObject(i);
            if (ssa == null) continue;
            if (studyIUID == null) {
                studyIUID = ssa.getString(0x20000D);
            }
            if ((ssaSpsID = ssa.getString(0x400009)) == null || spsid.equals(ssaSpsID)) {
                ssa.putString(524368, VR.SH, accNo);
                ssa.putString(0x400009, VR.SH, spsid);
                ssa.putString(0x401001, VR.SH, rpid);
                ssa.putString(0x20000D, VR.UI, studyIUID);
                spsNotInList = false;
                continue;
            }
            if (ssaSpsID == null || ssa.getString(524368) != null) continue;
            log.warn("MPPS contains an invalid ScheduledStepAttributes item! (with SPS Id but no Accession Number):" + ssa);
            if (i != 0) continue;
            invalidSSAItem0 = true;
        }
        if (spsNotInList) {
            ssa = new BasicDicomObject();
            if (invalidSSAItem0) {
                ssaSQ.addDicomObject(0, ssa);
            } else {
                ssaSQ.addDicomObject(ssa);
            }
            DicomObject spsDS = spsSq.getDicomObject();
            ssa.putString(0x20000D, VR.UI, studyIUID);
            ssa.putString(0x400009, VR.SH, spsid);
            ssa.putString(0x401001, VR.SH, rpid);
            ssa.putString(524368, VR.SH, accNo);
            ssa.putSequence(528656);
            ssa.putString(0x401001, VR.SH, rpid);
            ssa.putString(0x400007, VR.LO, spsDS.getString(0x400007));
            DicomElement mppsSPCSQ = ssa.putSequence(0x400008);
            DicomElement mwlSPCSQ = spsDS.get(0x400008);
            if (mwlSPCSQ != null) {
                int len2 = mwlSPCSQ.countItems();
                for (int i = 0; i < len2; ++i) {
                    BasicDicomObject codeItem = new BasicDicomObject();
                    mwlSPCSQ.getDicomObject(i).copyTo((DicomObject)codeItem);
                    mppsSPCSQ.addDicomObject((DicomObject)codeItem);
                }
            }
            log.debug("Add new ScheduledStepAttribute item: {}", (Object)ssa);
            log.debug("New mppsAttrs:{}", (Object)mppsAttrs);
        } else if (invalidSSAItem0) {
            ssa = ssaSQ.removeDicomObject(0);
            ssaSQ.addDicomObject(ssa);
        }
        mpps.setAttributes(mppsAttrs);
        this.em.merge((Object)mpps);
        Set series = mpps.getSeries();
        if (series.size() > 0) {
            Study s = ((Series)series.iterator().next()).getStudy();
            DicomObject sAttrs = s.getAttributes(true);
            sAttrs.putString(524368, VR.SH, accNo);
            s.setAttributes(sAttrs);
            this.em.merge((Object)s);
        }
    }

    @Override
    public MPPS unlinkMpps(long pk, boolean updateMwlStatus, String modifyingSystem, String modifyReason) {
        String spsId;
        String rpId;
        MPPS mpps = (MPPS)this.em.find(MPPS.class, (Object)pk);
        MPPS mppsSav = new MPPS();
        mppsSav.setAttributes(mpps.getAttributes());
        mpps.getPatient().getPatientID();
        mppsSav.setPatient(mpps.getPatient());
        DicomObject mppsAttrs = mpps.getAttributes();
        DicomElement ssaSQ = mppsAttrs.get(4194928);
        DicomObject item = null;
        MWLItem mwlItem = null;
        HashSet<String> rpspsIDs = new HashSet<String>(ssaSQ.countItems());
        Query qMwl = this.em.createQuery("select object(m) from MWLItem m where requestedProcedureID = :rpId and scheduledProcedureStepID = :spsId");
        int len = ssaSQ.countItems();
        for (int i = 0; i < len; ++i) {
            item = ssaSQ.getDicomObject(i);
            rpId = item.getString(0x401001);
            spsId = item.getString(0x400009);
            if (spsId == null) continue;
            rpspsIDs.add(rpId + "_" + spsId);
            if (!updateMwlStatus) continue;
            try {
                qMwl.setParameter("rpId", (Object)rpId).setParameter("spsId", (Object)spsId);
                mwlItem = (MWLItem)qMwl.getSingleResult();
                DicomObject mwlAttrs = mwlItem.getAttributes();
                mwlAttrs.get(0x400100).getDicomObject().putString(0x400020, VR.CS, "SCHEDULED");
                mwlItem.setAttributes(mwlAttrs);
                this.em.merge((Object)mwlItem);
                continue;
            }
            catch (Exception ignore) {
                log.warn("Can't update MWLItem status to SCHEDULED! MWL:" + mwlItem, (Throwable)ignore);
            }
        }
        String studyIUID = item.getString(0x20000D);
        item.clear();
        item.putString(0x20000D, VR.UI, studyIUID);
        item.putString(0x400009, VR.SH, null);
        item.putString(524368, VR.SH, null);
        item.putSequence(528656);
        item.putString(0x401001, VR.SH, null);
        item.putString(0x400007, VR.LO, null);
        item.putSequence(0x400008);
        mppsAttrs.putSequence(4194928).addDicomObject(item);
        mpps.setAttributes(mppsAttrs);
        this.em.merge((Object)mpps);
        if (rpspsIDs.size() > 0) {
            Series s2 = null;
            for (Series s2 : mpps.getSeries()) {
                DicomObject seriesAttrs = s2.getAttributes(true);
                DicomElement reqAttrSQ = seriesAttrs.get(4194933);
                if (reqAttrSQ != null) {
                    DicomElement newReqAttrSQ = seriesAttrs.putSequence(4194933);
                    int len2 = reqAttrSQ.countItems();
                    for (int i = 0; i < len2; ++i) {
                        DicomObject rqAttrSqItem = reqAttrSQ.getDicomObject(i);
                        rpId = rqAttrSqItem.getString(0x401001);
                        spsId = rqAttrSqItem.getString(0x400009);
                        if (rpspsIDs.contains(rpId + "_" + spsId)) continue;
                        newReqAttrSQ.addDicomObject(rqAttrSqItem);
                    }
                    if (newReqAttrSQ.isEmpty()) {
                        seriesAttrs.remove(4194933);
                    }
                }
                seriesAttrs.putString(524368, VR.SH, null);
                s2.setAttributes(seriesAttrs);
                this.em.merge((Object)s2);
            }
            if (s2 != null) {
                Study study = s2.getStudy();
                DicomObject studyAttrs = study.getAttributes(false);
                studyAttrs.putString(524368, VR.SH, null);
                study.setAttributes(studyAttrs);
                this.em.merge((Object)study);
            }
        }
        return mppsSav;
    }

    @Override
    public Map<String, DicomObject> updateSeriesAndStudyAttributes(String[] mppsIuids, DicomObject coerce) {
        StringBuilder sb = new StringBuilder("SELECT object(s) FROM Series s WHERE performedProcedureStepInstanceUID");
        QueryUtil.appendIN(sb, mppsIuids.length);
        Query qS = this.em.createQuery(sb.toString());
        QueryUtil.setParametersForIN(qS, mppsIuids);
        List seriess = qS.getResultList();
        log.info("Coerce Series and Study attributes after linking mpps to mwl: nr of series:" + seriess.size());
        HashMap<String, DicomObject> result = new HashMap<String, DicomObject>();
        if (seriess.size() > 0) {
            DicomObject seriesAndStudyAttrs = null;
            Study study = null;
            for (Series s : seriess) {
                seriesAndStudyAttrs = s.getAttributes(true);
                study = s.getStudy();
                this.addToResult(result, s, study);
                study.getAttributes(true).copyTo(seriesAndStudyAttrs);
                seriesAndStudyAttrs.remove(4194933);
                log.debug("Coerce SeriesAndStudy: orig:" + seriesAndStudyAttrs);
                log.debug("Coerce SeriesAndStudy: coerce:" + coerce);
                CoercionUtil.coerceAttributes(seriesAndStudyAttrs, coerce, null);
                log.debug("Set coerced SeriesAndStudy: " + seriesAndStudyAttrs);
                s.setAttributes(seriesAndStudyAttrs);
                this.em.merge((Object)s);
                log.debug("new Series Attrs: " + s.getAttributes(true));
            }
            study.setAttributes(seriesAndStudyAttrs);
            this.em.merge(study);
            log.debug("new Study Attrs: " + study.getAttributes(true));
        }
        return result;
    }

    @Override
    public void updateMPPSAttributes(MPPS mpps, DicomObject attrs) {
        mpps.setAttributes(attrs);
        this.em.merge((Object)mpps);
    }

    private void addToResult(Map<String, DicomObject> result, Series series, Study study) {
        DicomElement refSeriesSeq;
        Instance instance = null;
        Iterator it = series.getInstances().iterator();
        while (it.hasNext() && (instance = (Instance)it.next()).getAvailability().ordinal() > Availability.NEARLINE.ordinal()) {
            instance = null;
        }
        if (instance == null) {
            log.warn("No ONLINE or NEARLINE instance found for series:" + series.getSeriesInstanceUID() + "!");
            return;
        }
        DicomObject ian = result.get(study.getStudyInstanceUID());
        if (ian == null) {
            ian = new BasicDicomObject();
            ian.putString(0x20000D, VR.UI, study.getStudyInstanceUID());
            ian.putString(524368, VR.SH, study.getAccessionNumber());
            Patient pat = study.getPatient();
            ian.putString(0x100020, VR.LO, pat.getPatientID());
            ian.putString(0x100021, VR.LO, pat.getIssuerOfPatientID());
            ian.putString(0x100010, VR.PN, pat.getPatientName());
            result.put(study.getStudyInstanceUID(), ian);
        }
        if ((refSeriesSeq = ian.get(528661)) == null) {
            refSeriesSeq = ian.putSequence(528661);
        }
        BasicDicomObject refSerItem = new BasicDicomObject();
        refSerItem.putString(0x20000E, VR.UI, series.getSeriesInstanceUID());
        refSeriesSeq.addDicomObject((DicomObject)refSerItem);
        DicomElement refSopSeq = refSerItem.putSequence(528793);
        BasicDicomObject refSopItem = new BasicDicomObject();
        refSopSeq.addDicomObject((DicomObject)refSopItem);
        refSopItem.putString(524372, VR.AE, instance.getRetrieveAETs());
        refSopItem.putString(524374, VR.CS, Availability.ONLINE.name());
        refSopItem.putString(528720, VR.UI, instance.getSOPClassUID());
        refSopItem.putString(528725, VR.UI, instance.getSOPInstanceUID());
    }

    private void updateOriginalAttributeSequence(DicomObject attrs, DicomObject origAttrs, String modifyingSystem, String reason) {
        DicomElement origAttrsSq = attrs.get(67110241);
        if (origAttrsSq == null) {
            origAttrsSq = attrs.putSequence(67110241);
        }
        BasicDicomObject origAttrsItem = new BasicDicomObject();
        origAttrsItem.putString(67110244, VR.LO, null);
        origAttrsItem.putDate(67110242, VR.DT, new Date());
        origAttrsItem.putString(67110243, VR.LO, modifyingSystem);
        origAttrsItem.putString(67110245, VR.CS, reason);
        DicomElement modSq = origAttrsItem.putSequence(0x4000550);
        modSq.addDicomObject(origAttrs);
        origAttrsSq.addDicomObject((DicomObject)origAttrsItem);
    }

    @Override
    public List<Patient> selectOrCreatePatient(DicomObject patAttrs) {
        Query qPat;
        String patID = patAttrs.getString(0x100020);
        String issuer = patAttrs.getString(0x100021);
        if (issuer == null) {
            qPat = this.em.createQuery("select object(p) from Patient p where patientID = :patID");
            qPat.setParameter("patID", (Object)patID);
        } else {
            qPat = this.em.createQuery("select object(p) from Patient p where patientID = :patID and issuerOfPatientID = :issuer");
            qPat.setParameter("patID", (Object)patID).setParameter("issuer", (Object)issuer);
        }
        List pats = qPat.getResultList();
        if (pats.size() == 0) {
            log.info("create new Patient for linking MPPS to external worklist entry! patID:" + patID);
            Patient pat = new Patient();
            pat.setAttributes(patAttrs);
            this.em.persist((Object)pat);
            log.debug("Patient created:{}", (Object)pat.getAttributes());
            pats.add(pat);
        }
        log.info("return pat:" + pats);
        return pats;
    }
}

