/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4chee.archive.common.Availability;
import org.dcm4chee.archive.common.StorageStatus;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.File;
import org.dcm4chee.archive.entity.Instance;
import org.dcm4chee.archive.entity.MPPS;
import org.dcm4chee.archive.entity.Patient;
import org.dcm4chee.archive.entity.PrivateFile;
import org.dcm4chee.archive.entity.PrivateInstance;
import org.dcm4chee.archive.entity.PrivatePatient;
import org.dcm4chee.archive.entity.PrivateSeries;
import org.dcm4chee.archive.entity.PrivateStudy;
import org.dcm4chee.archive.entity.Series;
import org.dcm4chee.archive.entity.Study;
import org.dcm4chee.archive.entity.StudyOnFileSystem;
import org.dcm4chee.web.dao.common.DicomEditLocal;
import org.dcm4chee.web.dao.util.QueryUtil;
import org.dcm4chee.web.dao.util.UpdateDerivedFieldsUtil;
import org.dcm4chee.web.dao.vo.EntityTree;
import org.jboss.annotation.ejb.LocalBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/DicomEditBean/local")
public class DicomEditBean
implements DicomEditLocal {
    private static final int DELETED = 1;
    private static Logger log = LoggerFactory.getLogger(DicomEditBean.class);
    private UpdateDerivedFieldsUtil updateUtil;
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    private UpdateDerivedFieldsUtil getUpdateDerivedFieldsUtil() {
        if (this.updateUtil == null) {
            this.updateUtil = new UpdateDerivedFieldsUtil(this.em);
        }
        return this.updateUtil;
    }

    @Override
    public EntityTree moveInstancesToTrash(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(i) FROM Instance i WHERE i.pk ", pks);
        return this.moveInstancesToTrash(q.getResultList(), true);
    }

    @Override
    public EntityTree moveInstanceToTrash(String iuid) {
        Query q = this.em.createNamedQuery("Instance.findByIUID");
        q.setParameter("iuid", (Object)iuid.trim());
        return this.moveInstancesToTrash(q.getResultList(), true);
    }

    public EntityTree moveInstancesToTrash(Collection<Instance> instances, boolean deleteInstance) {
        return this.moveInstancesToTrash(instances, deleteInstance, null);
    }

    public EntityTree moveInstancesToTrash(Collection<Instance> instances, boolean deleteInstance, EntityTree entityTree) {
        log.debug("Move {} instances to trash!", (Object)instances.size());
        HashSet<Study> studies = new HashSet<Study>();
        for (Instance instance : instances) {
            this.moveInstanceToTrash(instance);
            if (!deleteInstance) continue;
            studies.add(instance.getSeries().getStudy());
            log.debug("Delete Instance:{}", (Object)instance.getAttributes(false));
            this.em.remove((Object)instance);
        }
        if (deleteInstance) {
            this.removeInstancesFromMpps(instances);
            for (Study st : studies) {
                this.getUpdateDerivedFieldsUtil().updateDerivedFieldsOfStudy(st);
            }
        }
        return entityTree == null ? new EntityTree(instances) : entityTree.addInstances(instances);
    }

    @Override
    public EntityTree moveSeriesToTrash(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(s) FROM Series s WHERE pk ", pks);
        return this.moveSeriesToTrash(q.getResultList(), true, null);
    }

    @Override
    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    public EntityTree moveSeriesToTrash(String iuid) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Series s WHERE seriesInstanceUID = :iuid").setParameter("iuid", (Object)iuid.trim());
        return this.moveSeriesToTrash(q.getResultList(), true, null);
    }

    private EntityTree moveSeriesToTrash(Collection<Series> series, boolean deleteSeries, EntityTree entityTree) {
        HashSet<Study> studies = new HashSet<Study>();
        for (Series s : series) {
            Set instances = s.getInstances();
            if (instances.isEmpty()) {
                log.info("move empty series to trash:{}", (Object)s.getSeriesInstanceUID());
                this.moveSeriesToTrash(s);
            } else {
                entityTree = this.moveInstancesToTrash(instances, false, entityTree);
            }
            MPPS mpps = s.getModalityPerformedProcedureStep();
            if (mpps != null) {
                mpps.getAccessionNumber();
            }
            if (!deleteSeries) continue;
            this.removeSeriesFromMPPS(mpps, s.getSeriesInstanceUID());
            Study study = s.getStudy();
            studies.add(study);
            this.em.remove((Object)s);
            study.getSeries().remove(s);
        }
        if (deleteSeries) {
            for (Study st : studies) {
                this.getUpdateDerivedFieldsUtil().updateDerivedFieldsOfStudy(st);
            }
        }
        return entityTree == null ? new EntityTree() : entityTree;
    }

    @Override
    public EntityTree moveSeriesOfPpsToTrash(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(p) FROM MPPS p WHERE pk ", pks);
        Query qs = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(s) FROM Series s WHERE s.modalityPerformedProcedureStep.pk ", pks);
        List seriess = qs.getResultList();
        EntityTree tree = this.moveSeriesToTrash(seriess, true, null);
        List mppss = q.getResultList();
        for (MPPS mpps : mppss) {
            this.em.remove((Object)mpps);
        }
        return tree;
    }

    @Override
    public EntityTree moveStudiesToTrash(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(s) FROM Study s WHERE pk ", pks);
        return this.moveStudiesToTrash(q.getResultList(), null);
    }

    @Override
    public EntityTree moveStudyToTrash(String iuid) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Study s WHERE studyInstanceUID = :iuid").setParameter("iuid", (Object)iuid.trim());
        return this.moveStudiesToTrash(q.getResultList(), null);
    }

    private EntityTree moveStudiesToTrash(Collection<Study> studies, EntityTree entityTree) {
        for (Study st : studies) {
            Set series = st.getSeries();
            if (series.isEmpty()) {
                log.info("move empty study to trash:{}", (Object)st.getStudyInstanceUID());
                this.moveStudyToTrash(st);
            } else {
                entityTree = this.moveSeriesToTrash(series, false, entityTree);
            }
            log.debug("Delete Study:{}", (Object)st.getAttributes(false));
            Query q = this.em.createQuery("SELECT OBJECT(sof) FROM StudyOnFileSystem sof WHERE study_fk = :pk");
            q.setParameter("pk", (Object)st.getPk());
            for (StudyOnFileSystem sof : q.getResultList()) {
                this.em.remove((Object)sof);
            }
            this.em.remove((Object)st);
        }
        return entityTree == null ? new EntityTree() : entityTree;
    }

    @Override
    public EntityTree movePatientsToTrash(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(p) FROM Patient p WHERE pk ", pks);
        return this.movePatientsToTrash(q.getResultList(), null);
    }

    @Override
    public EntityTree movePatientToTrash(String patId, String issuer) {
        return this.movePatientsToTrash(QueryUtil.getPatientQuery(this.em, patId, issuer).getResultList(), null);
    }

    private EntityTree movePatientsToTrash(Collection<Patient> patients, EntityTree entityTree) {
        if (entityTree == null) {
            entityTree = new EntityTree();
        }
        for (Patient p : patients) {
            Set studies = p.getStudies();
            if (studies == null || studies.isEmpty()) {
                log.debug("move empty patient to trash:" + p.getPatientID() + "^^^" + p.getIssuerOfPatientID() + ":" + p.getPatientName());
                this.movePatientToTrash(p);
                entityTree.addPatient(p);
            } else {
                entityTree = this.moveStudiesToTrash(studies, entityTree);
                studies.clear();
            }
            this.deletePatient(p);
        }
        return entityTree;
    }

    private void moveInstanceToTrash(Instance instance) {
        DicomObject attrs = instance.getAttributes(false);
        PrivateInstance pInst = new PrivateInstance();
        pInst.setAttributes(attrs);
        pInst.setPrivateType(1);
        Series series = instance.getSeries();
        PrivateSeries ps = this.moveSeriesToTrash(series);
        pInst.setSeries(ps);
        for (File f : instance.getFiles()) {
            PrivateFile pf = new PrivateFile();
            pf.setFileSystem(f.getFileSystem());
            f.getFileSystem().getAvailability();
            pf.setFilePath(f.getFilePath());
            pf.setTransferSyntaxUID(f.getTransferSyntaxUID());
            pf.setFileStatus(f.getFileStatus());
            pf.setFileSize(f.getFileSize());
            pf.setFileMD5(f.getMD5Sum());
            pf.setInstance(pInst);
            this.em.persist((Object)pf);
        }
        this.em.persist((Object)pInst);
    }

    private PrivateSeries moveSeriesToTrash(Series series) {
        PrivateSeries pSeries;
        try {
            Query q = this.em.createNamedQuery("PrivateSeries.findByIUID");
            q.setParameter("iuid", (Object)series.getSeriesInstanceUID());
            pSeries = (PrivateSeries)q.getSingleResult();
            series.getStudy().getPatient().getPk();
        }
        catch (NoResultException nre) {
            pSeries = new PrivateSeries();
            DicomObject attrs = series.getAttributes(false);
            attrs.putString(attrs.resolveTag(4390932, "dcm4che/archive"), VR.AE, series.getSourceAET());
            pSeries.setAttributes(attrs);
            pSeries.setPrivateType(1);
            Study study = series.getStudy();
            PrivateStudy pStudy = this.moveStudyToTrash(study);
            pSeries.setStudy(pStudy);
            this.em.persist((Object)pSeries);
        }
        return pSeries;
    }

    private PrivateStudy moveStudyToTrash(Study study) {
        PrivateStudy pStudy;
        try {
            Query q = this.em.createNamedQuery("PrivateStudy.findByIUID");
            q.setParameter("iuid", (Object)study.getStudyInstanceUID());
            pStudy = (PrivateStudy)q.getSingleResult();
            study.getPatient().getPk();
        }
        catch (NoResultException nre) {
            pStudy = new PrivateStudy();
            pStudy.setAttributes(study.getAttributes(false));
            pStudy.setPrivateType(1);
            Patient pat = study.getPatient();
            PrivatePatient pPat = this.movePatientToTrash(pat);
            pStudy.setPatient(pPat);
            this.em.persist((Object)pStudy);
        }
        return pStudy;
    }

    private PrivatePatient movePatientToTrash(Patient patient) {
        PrivatePatient pPat;
        block5: {
            pPat = null;
            try {
                if (patient.getIssuerOfPatientID() != null) {
                    Query q = this.em.createNamedQuery("PrivatePatient.findByIdAndIssuer");
                    q.setParameter("patId", (Object)patient.getPatientID());
                    q.setParameter("issuer", (Object)patient.getIssuerOfPatientID());
                    pPat = (PrivatePatient)q.getSingleResult();
                    break block5;
                }
                Query q = this.em.createQuery("select object(p) from PrivatePatient p where patientID = :patId and patientName = :name");
                q.setParameter("patId", (Object)patient.getPatientID());
                q.setParameter("name", (Object)patient.getPatientName());
                List pList = q.getResultList();
                String birthdate = patient.getAttributes().getString(0x100030, "X");
                int len = pList.size();
                for (int i = 0; i < len; ++i) {
                    PrivatePatient p = (PrivatePatient)pList.get(i);
                    if (!p.getAttributes().getString(0x100030, "X").equals(birthdate)) continue;
                    pPat = p;
                    break;
                }
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
        }
        if (pPat == null) {
            pPat = new PrivatePatient();
            pPat.setAttributes(patient.getAttributes());
            pPat.setPrivateType(1);
            this.em.persist((Object)pPat);
        }
        return pPat;
    }

    private void deletePatient(Patient patient) {
        log.info("Delete Patient:{}", (Object)patient);
        Set mppss = patient.getModalityPerformedProcedureSteps();
        if (mppss != null) {
            for (MPPS mpps : mppss) {
                Set seriess = mpps.getSeries();
                if (seriess == null || seriess.isEmpty()) {
                    this.em.remove((Object)mpps);
                    continue;
                }
                Patient pat = ((Series)seriess.iterator().next()).getStudy().getPatient();
                log.warn("Wrong patient in MPPS found!\n corrected from:" + mpps.getPatient() + "\nto:" + pat);
                mpps.setPatient(pat);
            }
        }
        this.delete(patient.getModalityWorklistItems());
        this.delete(patient.getGeneralPurposeScheduledProcedureSteps());
        this.delete(patient.getGeneralPurposePerformedProcedureSteps());
        this.em.flush();
        this.em.refresh((Object)patient);
        this.em.remove((Object)patient);
    }

    private void delete(Set<? extends BaseEntity> entities) {
        if (entities != null) {
            for (BaseEntity baseEntity : entities) {
                this.em.remove((Object)baseEntity);
                log.info("Deleted: {}", (Object)baseEntity);
            }
        }
    }

    @Override
    public List<MPPS> deletePps(long[] pks) {
        Query q = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(p) FROM MPPS p WHERE pk ", pks);
        List mppss = q.getResultList();
        for (MPPS mpps : mppss) {
            for (Series series : mpps.getSeries()) {
                DicomObject seriesAttrs = series.getAttributes(true);
                seriesAttrs.remove(528657);
                seriesAttrs.remove(0x400244);
                seriesAttrs.remove(4194885);
                series.setAttributes(seriesAttrs);
                series.setModalityPerformedProcedureStep(null);
                this.em.merge((Object)series);
            }
            mpps.getPatient().getPatientID();
            this.em.remove((Object)mpps);
        }
        return mppss;
    }

    @Override
    public EntityTree moveStudiesToPatient(long[] pks, long pk) {
        Query qP = this.em.createQuery("SELECT OBJECT(p) FROM Patient p WHERE pk = :pk").setParameter("pk", (Object)pk);
        Query qS = QueryUtil.getQueryForPks(this.em, "SELECT OBJECT(s) FROM Study s WHERE pk ", pks);
        return this.moveStudiesToPatient(qS.getResultList(), (Patient)qP.getSingleResult());
    }

    @Override
    public EntityTree moveStudyToPatient(String iuid, String patId, String issuer) {
        Query qS = this.em.createQuery("SELECT OBJECT(s) FROM Study s WHERE studyInstanceUID = :iuid").setParameter("iuid", (Object)iuid.trim());
        Query qP = QueryUtil.getPatientQuery(this.em, patId, issuer);
        return this.moveStudiesToPatient(qS.getResultList(), (Patient)qP.getSingleResult());
    }

    private EntityTree moveStudiesToPatient(List<Study> studies, Patient patient) {
        EntityTree tree = new EntityTree();
        for (Study s : studies) {
            tree.addStudy(s);
            s.setPatient(patient);
            for (Series series : s.getSeries()) {
                MPPS mpps = series.getModalityPerformedProcedureStep();
                if (mpps == null) continue;
                mpps.setPatient(patient);
                this.em.merge((Object)mpps);
            }
        }
        return tree;
    }

    @Override
    public DicomObject getCompositeObjectforSeries(String iuid) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Series s WHERE seriesInstanceUID = :iuid").setParameter("iuid", (Object)iuid.trim());
        Series s = (Series)q.getSingleResult();
        DicomObject attrs = s.getAttributes(false);
        attrs.putString(attrs.resolveTag(4390932, "dcm4che/archive"), VR.AE, s.getSourceAET());
        s.getStudy().getAttributes(false).copyTo(attrs);
        s.getStudy().getPatient().getAttributes().copyTo(attrs);
        return attrs;
    }

    @Override
    public DicomObject getCompositeObjectforSeries(long pk) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Series s WHERE pk = :pk").setParameter("pk", (Object)pk);
        Series s = (Series)q.getSingleResult();
        DicomObject attrs = s.getAttributes(false);
        s.getStudy().getAttributes(false).copyTo(attrs);
        s.getStudy().getPatient().getAttributes().copyTo(attrs);
        return attrs;
    }

    @Override
    public DicomObject getCompositeObjectforStudy(String studyIuid) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Study s WHERE studyInstanceUID = :iuid").setParameter("iuid", (Object)studyIuid.trim());
        Study s = (Study)q.getSingleResult();
        DicomObject attrs = s.getAttributes(false);
        s.getPatient().getAttributes().copyTo(attrs);
        return attrs;
    }

    @Override
    public DicomObject getCompositeObjectforStudy(long pk) {
        Query q = this.em.createQuery("SELECT OBJECT(s) FROM Study s WHERE pk = :pk").setParameter("pk", (Object)pk);
        Study s = (Study)q.getSingleResult();
        DicomObject attrs = s.getAttributes(false);
        s.getPatient().getAttributes().copyTo(attrs);
        return attrs;
    }

    @Override
    public DicomObject getPatientAttributes(String patId, String issuer) {
        return ((Patient)QueryUtil.getPatientQuery(this.em, patId, issuer).getSingleResult()).getAttributes();
    }

    @Override
    public DicomObject getPatientAttributes(long pk) {
        Query q = this.em.createQuery("SELECT OBJECT(p) FROM Patient p WHERE pk = :pk").setParameter("pk", (Object)pk);
        return ((Patient)q.getSingleResult()).getAttributes();
    }

    @Override
    public Series updateSeries(Series series) {
        if (series.getPk() == -1L) {
            if (series.getStudy().getPk() == -1L) {
                this.updateStudy(series.getStudy());
            }
            this.em.persist((Object)series);
        } else {
            this.em.merge((Object)series);
        }
        return series;
    }

    @Override
    public Series createSeries(DicomObject seriesAttrs, long studyPk) {
        Study study = (Study)this.em.find(Study.class, (Object)studyPk);
        Series series = new Series();
        series.setAvailability(Availability.ONLINE);
        series.setNumberOfSeriesRelatedInstances(0);
        series.setStorageStatus(StorageStatus.STORED);
        series.setAttributes(seriesAttrs);
        series.setStudy(study);
        this.em.persist((Object)series);
        return series;
    }

    @Override
    public void removeSeries(long seriesPk) {
        Series series = (Series)this.em.find(Series.class, (Object)seriesPk);
        this.em.remove((Object)series);
    }

    @Override
    public int removeForeignPpsInfo(long studyPk) {
        int count = 0;
        Study study = (Study)this.em.find(Study.class, (Object)studyPk);
        for (Series s : study.getSeries()) {
            if (s.getPerformedProcedureStepInstanceUID() == null || s.getModalityPerformedProcedureStep() != null) continue;
            DicomObject attrs = s.getAttributes(true);
            attrs.remove(528657);
            s.setAttributes(attrs);
            this.em.merge((Object)s);
            ++count;
        }
        return count;
    }

    @Override
    public Study updateStudy(Study study) {
        if (study.getPk() == -1L) {
            if (study.getPatient().getPk() == -1L) {
                this.em.persist((Object)study.getPatient());
            }
            this.em.persist((Object)study);
        } else {
            this.em.merge((Object)study);
        }
        return study;
    }

    @Override
    public Study createStudy(DicomObject studyAttrs, long patPk) {
        Patient patient = (Patient)this.em.find(Patient.class, (Object)patPk);
        Study study = new Study();
        study.setAttributes(studyAttrs);
        study.setAvailability(Availability.ONLINE);
        study.setNumberOfStudyRelatedInstances(0);
        study.setNumberOfStudyRelatedSeries(0);
        study.setPatient(patient);
        this.em.persist((Object)study);
        return study;
    }

    @Override
    public void removeStudy(long studyPk) {
        Study study = (Study)this.em.find(Study.class, (Object)studyPk);
        this.em.remove((Object)study);
    }

    @Override
    public DicomObject getIanForForwardModifiedObject(DicomObject obj, String level) {
        Instance instance = null;
        if ("IMAGE".equals(level)) {
            instance = this.findFirstOnlineInstance("SELECT OBJECT(i) FROM Instance i WHERE sopInstanceUID = :iuid", obj.getString(524312));
        } else if ("SERIES".equals(level)) {
            instance = this.findFirstOnlineInstance("SELECT OBJECT(i) FROM Instance i WHERE i.series.seriesInstanceUID = :iuid", obj.getString(0x20000E));
        } else if ("STUDY".equals(level)) {
            instance = this.findFirstOnlineInstance("SELECT OBJECT(i) FROM Instance i WHERE i.series.study.studyInstanceUID = :iuid", obj.getString(0x20000D));
        } else {
            throw new IllegalArgumentException("Illegal QR Level! (must be STUDY, SERIES or IMAGE):" + level);
        }
        if (instance == null) {
            return null;
        }
        Series series = instance.getSeries();
        Study study = series.getStudy();
        Patient pat = study.getPatient();
        BasicDicomObject ian = new BasicDicomObject();
        ian.putString(0x20000D, VR.UI, study.getStudyInstanceUID());
        ian.putString(524368, VR.SH, study.getAccessionNumber());
        ian.putString(0x100020, VR.LO, pat.getPatientID());
        ian.putString(0x100021, VR.LO, pat.getIssuerOfPatientID());
        ian.putString(0x100010, VR.PN, pat.getPatientName());
        ian.putSequence(528657);
        DicomElement refSeriesSeq = ian.putSequence(528661);
        BasicDicomObject refSerItem = new BasicDicomObject();
        refSerItem.putString(0x20000E, VR.UI, series.getSeriesInstanceUID());
        refSeriesSeq.addDicomObject((DicomObject)refSerItem);
        DicomElement refSopSeq = refSerItem.putSequence(528793);
        BasicDicomObject refSopItem = new BasicDicomObject();
        refSopSeq.addDicomObject((DicomObject)refSopItem);
        refSopItem.putString(524372, VR.AE, instance.getRetrieveAETs());
        refSopItem.putString(524374, VR.CS, Availability.ONLINE.name());
        refSopItem.putString(528720, VR.UI, instance.getSOPClassUID());
        refSopItem.putString(528725, VR.UI, instance.getSOPInstanceUID());
        return ian;
    }

    private Instance findFirstOnlineInstance(String query, String uid) {
        Query q = this.em.createQuery(query);
        q.setParameter("iuid", (Object)uid);
        List l = q.getResultList();
        log.debug("findFirstOnlineInstance with query:{} with iuid:{}", (Object)query, (Object)uid);
        log.debug("Found instances: {}", (Object)l.size());
        int len = l.size();
        for (int i = 0; i < len; ++i) {
            if (((Instance)l.get(i)).getAvailability().ordinal() > Availability.NEARLINE.ordinal()) continue;
            return (Instance)l.get(i);
        }
        log.debug("No instance (ONLINE) found!");
        return null;
    }

    private void removeSeriesFromMPPS(MPPS mpps, String seriesIUID) {
        if (mpps != null && mpps.getAttributes() != null) {
            DicomObject mppsAttrs = mpps.getAttributes();
            this.removeFromMPPS(mppsAttrs, seriesIUID, null);
            mpps.setAttributes(mppsAttrs);
            this.em.merge((Object)mpps);
        }
    }

    private void removeFromMPPS(DicomObject mppsAttrs, String seriesIUID, Collection<String> sopIUIDs) {
        DicomElement psSq = mppsAttrs.get(0x400340);
        if (psSq == null) {
            log.warn("Missing Performed Series Sequence in MPPS! mpps\n:" + mppsAttrs);
            return;
        }
        for (int i = psSq.countItems() - 1; i >= 0; --i) {
            DicomObject psItem = psSq.getDicomObject(i);
            if (!seriesIUID.equals(psItem.getString(0x20000E))) continue;
            if (sopIUIDs == null) {
                psSq.removeDicomObject(i);
                break;
            }
            DicomElement refImgSq = psItem.get(528704);
            for (int j = refImgSq.countItems() - 1; j >= 0; --j) {
                DicomObject refImgItem = refImgSq.getDicomObject(j);
                if (!sopIUIDs.contains(refImgItem.getString(528725))) continue;
                refImgSq.removeDicomObject(j);
            }
        }
    }

    private void removeInstancesFromMpps(Collection<Instance> instances) {
        Series s;
        HashMap<Series, HashSet<String>> map = new HashMap<Series, HashSet<String>>();
        for (Instance instance : instances) {
            s = instance.getSeries();
            HashSet<String> iuidsPerSeries = (HashSet<String>)map.get(s);
            if (iuidsPerSeries == null) {
                iuidsPerSeries = new HashSet<String>();
                map.put(s, iuidsPerSeries);
            }
            iuidsPerSeries.add(instance.getSOPInstanceUID());
        }
        for (Map.Entry entry : map.entrySet()) {
            s = (Series)entry.getKey();
            MPPS mpps = s.getModalityPerformedProcedureStep();
            if (mpps == null || mpps.getAttributes() == null) continue;
            DicomObject mppsAttrs = mpps.getAttributes();
            this.removeFromMPPS(mppsAttrs, s.getSeriesInstanceUID(), (Collection)entry.getValue());
            mpps.setAttributes(mppsAttrs);
            try {
                this.em.merge((Object)mpps);
            }
            catch (Throwable x) {
                log.warn("MPPS update failed! mpps:" + mpps);
            }
        }
    }
}

