/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.web.dao.ae;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.dcm4chee.archive.entity.AE;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.dao.ae.AEHomeLocal;
import org.jboss.annotation.ejb.LocalBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@LocalBinding(jndiBinding="dcm4chee-web-ear/AEHomeBean/local")
public class AEHomeBean
implements AEHomeLocal {
    @PersistenceContext(unitName="dcm4chee-arc")
    private EntityManager em;

    @Override
    public List<String> listAETitles() {
        return this.em.createQuery("SELECT ae.title FROM AE ae ORDER BY ae.title").getResultList();
    }

    @Override
    public List<AE> findAll(String filter) {
        String filterQuery = filter == null ? "" : ("<NONE>".equals(filter) ? "WHERE aeGroup IS NULL" : "WHERE aeGroup = :filter");
        Query query = this.em.createQuery("FROM AE ae " + filterQuery + " ORDER BY ae.title, ae.aeGroup");
        if (filter != null && !"<NONE>".equals(filter)) {
            query.setParameter("filter", (Object)filter);
        }
        List l = query.getResultList();
        this.em.clear();
        return l;
    }

    @Override
    public AE findByTitle(String title) {
        Query q = this.em.createNamedQuery("AE.findByTitle");
        q.setParameter("title", (Object)title);
        return (AE)q.getSingleResult();
    }

    @Override
    public AE updateOrCreateAET(AE ae) {
        if (ae.getPk() == -1L) {
            this.em.persist((Object)ae);
            return null;
        }
        AE oldAE = (AE)this.em.find(AE.class, (Object)ae.getPk());
        String oldAETitle = oldAE.getTitle();
        this.em.merge((Object)ae);
        ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).updateAETInAETGroups(oldAETitle, ae.getTitle());
        return oldAE;
    }

    @Override
    public void removeAET(long pk) {
        AE ae = (AE)this.em.find(AE.class, (Object)pk);
        this.em.remove((Object)ae);
        ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).removeAETFromAETGroups(ae.getTitle());
    }

    @Override
    public List<String> listAeTypes() {
        return this.em.createQuery("SELECT DISTINCT ae.aeGroup FROM AE ae ORDER BY ae.aeGroup").getResultList();
    }
}

