/*
 * Decompiled with CFR 0.152.
 */
package org.regenstrief.xhl7;

import java.io.ByteArrayInputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.net.ServerSocketFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.regenstrief.xhl7.MLLPDriver;
import org.regenstrief.xhl7.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MLLPServer
extends Thread {
    private static Map _serverNameMap = new IdentityHashMap();
    private String _id = null;
    private Templates _templates = null;
    private Templates _errorTemplates = null;
    private Class _readerClass = null;
    private Class _writerClass = null;
    private static final int NO_PORT = -1;
    private int _portNumber = -1;
    private ServerSocketFactory _serverSocketFactory = ServerSocketFactory.getDefault();
    private static final int DEFAULT_BACKLOG = 10;
    private int _backlog = 10;

    public static void main(String[] args) throws Exception {
        MLLPServer.init(args[0]);
    }

    private static void init(String url) throws Exception {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setContentHandler(new ConfigurationHandler());
        InputSource isource = new InputSource(new URL(url).openStream());
        isource.setSystemId(url);
        reader.parse(isource);
    }

    private MLLPServer(String id) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (_serverNameMap.containsKey(id = id.intern())) {
            throw new IllegalArgumentException("duplicate server ids " + id);
        }
        this._id = id;
        _serverNameMap.put(id, this);
    }

    private void setTemplates(Templates templates) {
        if (templates == null) {
            throw new NullPointerException("templates");
        }
        this._templates = templates;
    }

    private void setErrorTemplates(Templates templates) {
        if (templates == null) {
            throw new NullPointerException("templates");
        }
        this._errorTemplates = templates;
    }

    private void setReaderClass(Class readerClass) {
        if (readerClass == null) {
            throw new NullPointerException("readerClass");
        }
        this._readerClass = readerClass;
    }

    private void setWriterClass(Class writerClass) {
        if (writerClass == null) {
            throw new NullPointerException("writerClass");
        }
        this._writerClass = writerClass;
    }

    private void setPortNumber(int portNumber) {
        if (portNumber == -1) {
            throw new IllegalArgumentException("invalid port number " + portNumber);
        }
        this._portNumber = portNumber;
    }

    private void setServerSocketFactory(ServerSocketFactory serverSocketFactory) {
        if (serverSocketFactory == null) {
            throw new NullPointerException("serverSocketFactory argument is null");
        }
        this._serverSocketFactory = serverSocketFactory;
    }

    private void setBacklog(int backlog) {
        if (backlog <= 0) {
            throw new IllegalArgumentException("invalid backlog " + backlog);
        }
        this._backlog = backlog;
    }

    public void run() {
        if (this._portNumber == -1) {
            throw new Error("no port number");
        }
        if (this._templates == null) {
            throw new Error("no templates");
        }
        ServerSocket acceptor = null;
        try {
            acceptor = this._serverSocketFactory.createServerSocket(this._portNumber, this._backlog);
        }
        catch (Exception ex) {
            throw new Error(ex);
        }
        System.err.println("[" + this._id + "] accepting connections on " + acceptor.getClass().getName() + " " + acceptor.getInetAddress() + " " + acceptor.getLocalPort());
        while (true) {
            Socket connection = null;
            try {
                connection = acceptor.accept();
            }
            catch (Exception ex) {
                throw new Error(ex);
            }
            try {
                new ClientHandler(connection).start();
            }
            catch (Exception exception) {
            }
        }
    }

    private class ClientHandler
    extends Thread {
        public static final String PAR_EXCEPTION = "exception";
        public static final String PAR_SERVER_ID = "serverId";
        public static final String PAR_REMOTE_ADDR = "remoteSocketAddress";
        private Socket _connection;

        ClientHandler(Socket connection) {
            this._connection = connection;
        }

        public void run() {
            System.err.println("[" + MLLPServer.this._id + "] serving " + this._connection.getRemoteSocketAddress());
            try {
                Result result;
                Transformer transformer = MLLPServer.this._templates.newTransformer();
                transformer.setParameter(PAR_REMOTE_ADDR, this._connection.getRemoteSocketAddress());
                MLLPDriver mllpDriver = new MLLPDriver(this._connection.getInputStream(), this._connection.getOutputStream(), false);
                Source source = MLLPServer.this._readerClass != null ? new SAXSource((XMLReader)MLLPServer.this._readerClass.newInstance(), new InputSource(mllpDriver.getInputStream())) : new StreamSource(mllpDriver.getInputStream());
                source.setSystemId("file:" + MLLPServer.this._id + "/");
                if (MLLPServer.this._writerClass != null) {
                    XMLWriter writer = (XMLWriter)MLLPServer.this._writerClass.newInstance();
                    writer.setOutputStream(mllpDriver.getOutputStream());
                    result = new SAXResult(writer.getContentHandler());
                } else {
                    result = new StreamResult(mllpDriver.getOutputStream());
                }
                result.setSystemId("file:ababa");
                while (mllpDriver.hasMoreInput()) {
                    block7: {
                        try {
                            transformer.transform(source, result);
                            mllpDriver.turn();
                        }
                        catch (Exception ex) {
                            System.err.println("[" + MLLPServer.this._id + "] ERROR " + ex.getMessage());
                            ex.printStackTrace(System.err);
                            mllpDriver.discardPendingOutput();
                            if (MLLPServer.this._errorTemplates == null) break block7;
                            Transformer errorTransformer = MLLPServer.this._errorTemplates.newTransformer();
                            errorTransformer.setParameter(PAR_SERVER_ID, MLLPServer.this._id);
                            errorTransformer.setParameter(PAR_REMOTE_ADDR, this._connection.getRemoteSocketAddress());
                            errorTransformer.setParameter(PAR_EXCEPTION, ex);
                            errorTransformer.transform(new StreamSource(new ByteArrayInputStream("<null/>".getBytes())), result);
                            mllpDriver.turn();
                        }
                    }
                    System.err.println("[" + MLLPServer.this._id + "] message done from " + this._connection.getRemoteSocketAddress());
                }
                System.err.println("[" + MLLPServer.this._id + "] server exit from " + this._connection.getRemoteSocketAddress());
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
                throw new Error(ex);
            }
        }
    }

    private static class ConfigurationHandler
    implements ContentHandler {
        MLLPServer _currentServer = null;
        TransformerFactory _currentTransformerFactory = null;
        static final String TAG_ROOT = "mllp";
        static final String TAG_SERVER = "server";
        static final String TAG_PORT = "port";
        static final String TAG_BACKLOG = "backlog";
        static final String TAG_SERVER_SOCKET_FACTORY = "serverSocketFactory";
        static final String TAG_TRANSFORMER_FACTORY = "transformerFactory";
        static final String TAG_TRANSFORM = "transform";
        static final String TAG_ERROR = "error";
        static final String TAG_READER = "reader";
        static final String TAG_WRITER = "writer";
        static final String ATT_SERVER_ID = "id";
        static final String ATT_PORT_NUMBER = "number";
        static final String ATT_BACKLOG_VALUE = "value";
        static final String ATT_SERVER_SOCKET_FACTORY_CLASS = "class";
        static final String ATT_TRANSFORMER_FACTORY_CLASS = "class";
        static final String ATT_TRANSFORM_HREF = "href";
        static final String ATT_ERROR_HREF = "href";
        static final String ATT_READER_CLASS = "class";
        static final String ATT_WRITER_CLASS = "class";

        private ConfigurationHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if ((localName = localName.intern()) != TAG_ROOT) {
                if (localName == TAG_SERVER) {
                    if (this._currentServer != null) {
                        throw new SAXException("nested " + localName + " elements");
                    }
                    String id = atts.getValue(ATT_SERVER_ID);
                    if (id == null) {
                        throw new SAXException(localName + " must have an id attribute");
                    }
                    this._currentServer = new MLLPServer(id);
                } else if (localName == TAG_PORT) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String portNumberString = atts.getValue(ATT_PORT_NUMBER);
                    if (portNumberString == null) {
                        throw new SAXException(localName + " must have a " + ATT_PORT_NUMBER + " attribute");
                    }
                    int portNumber = Integer.parseInt(portNumberString);
                    this._currentServer.setPortNumber(portNumber);
                } else if (localName == TAG_BACKLOG) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String backlogString = atts.getValue(ATT_BACKLOG_VALUE);
                    if (backlogString == null) {
                        throw new SAXException(localName + " must have a " + ATT_BACKLOG_VALUE + " attribute");
                    }
                    int backlog = Integer.parseInt(backlogString);
                    this._currentServer.setBacklog(backlog);
                } else if (localName == TAG_SERVER_SOCKET_FACTORY) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String className = atts.getValue("class");
                    if (className == null) {
                        throw new SAXException(localName + " must have a " + "class" + " attribute");
                    }
                    try {
                        this._currentServer.setServerSocketFactory((ServerSocketFactory)Class.forName(className).getMethod("getDefault", null).invoke(null, (Object[])null));
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else if (localName == TAG_READER) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String className = atts.getValue("class");
                    if (className == null) {
                        throw new SAXException(localName + " must have a " + "class" + " attribute");
                    }
                    try {
                        Class<?> readerClass = Class.forName(className);
                        this._currentServer.setReaderClass(readerClass);
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else if (localName == TAG_WRITER) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String className = atts.getValue("class");
                    if (className == null) {
                        throw new SAXException(localName + " must have a " + "class" + " attribute");
                    }
                    try {
                        Class<?> writerClass = Class.forName(className);
                        this._currentServer.setWriterClass(writerClass);
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else if (localName == TAG_TRANSFORMER_FACTORY) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    String className = atts.getValue("class");
                    if (className == null) {
                        throw new SAXException(localName + " must have a " + "class" + " attribute");
                    }
                    try {
                        this._currentTransformerFactory = (TransformerFactory)Class.forName(className).newInstance();
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else if (localName == TAG_TRANSFORM) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    if (this._currentTransformerFactory == null) {
                        throw new SAXException(localName + " must follow a " + TAG_TRANSFORMER_FACTORY + " element");
                    }
                    String href = atts.getValue("href");
                    if (href == null) {
                        throw new SAXException(localName + " must have a " + "href" + " attribute");
                    }
                    try {
                        StreamSource transformSource = new StreamSource(new URL(href).openStream());
                        this._currentServer.setTemplates(this._currentTransformerFactory.newTemplates(transformSource));
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else if (localName == TAG_ERROR) {
                    if (this._currentServer == null) {
                        throw new SAXException(localName + " must be in a " + TAG_SERVER + " element");
                    }
                    if (this._currentTransformerFactory == null) {
                        throw new SAXException(localName + " must follow a " + TAG_TRANSFORMER_FACTORY + " element");
                    }
                    String href = atts.getValue("href");
                    if (href == null) {
                        throw new SAXException(localName + " must have a " + "href" + " attribute");
                    }
                    try {
                        StreamSource transformSource = new StreamSource(new URL(href).openStream());
                        this._currentServer.setErrorTemplates(this._currentTransformerFactory.newTemplates(transformSource));
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                } else {
                    throw new SAXException("schema error, illegal element " + localName);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if ((localName = localName.intern()) != TAG_ROOT) {
                if (localName == TAG_SERVER) {
                    this._currentServer.start();
                    this._currentTransformerFactory = null;
                    this._currentServer = null;
                } else if (localName != TAG_PORT && localName != TAG_BACKLOG && localName != TAG_SERVER_SOCKET_FACTORY && localName != TAG_READER && localName != TAG_WRITER && localName != TAG_TRANSFORMER_FACTORY && localName != TAG_TRANSFORM && localName != TAG_ERROR) {
                    throw new SAXException("schema error, illegal element " + localName);
                }
            }
        }

        public void characters(char[] ch, int start, int length) {
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        public void endPrefixMapping(String prefix) {
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String name) {
        }
    }
}

