/*
 * Decompiled with CFR 0.152.
 */
package org.regenstrief.xhl7;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class MLLPDriver {
    private InputStream _inputStream;
    private OutputStream _outputStream;
    private boolean _clearToSend;
    private boolean _sending;
    private boolean _receiving;
    private boolean _inputClosed;
    private static final byte SOT = 11;
    private static final byte[] EOT = new byte[]{28, 13};
    private InputStream _proxyInputStream = new InputStream(){

        public int read() throws IOException {
            int b;
            if (MLLPDriver.this._inputClosed || MLLPDriver.this._clearToSend) {
                return -1;
            }
            if (MLLPDriver.this._sending) {
                MLLPDriver.this.endSending();
            }
            if (!MLLPDriver.this._receiving) {
                MLLPDriver.this.beginReceiving();
                if (MLLPDriver.this._inputClosed) {
                    return -1;
                }
            }
            if ((b = MLLPDriver.this._inputStream.read()) == EOT[0]) {
                MLLPDriver.this.endReceiving();
                return -1;
            }
            if (b == -1) {
                MLLPDriver.this._inputClosed = true;
            }
            return b;
        }

        public void close() throws IOException {
            MLLPDriver.this._inputStream.close();
            MLLPDriver.this._inputClosed = true;
        }
    };
    private ByteArrayOutputStream _outputBuffer = new ByteArrayOutputStream();
    private OutputStream _proxyOutputStream = new OutputStream(){

        public void write(int b) throws IOException {
            if (!MLLPDriver.this._sending && MLLPDriver.this._clearToSend) {
                MLLPDriver.this.beginSending();
            }
            if (MLLPDriver.this._sending) {
                MLLPDriver.this._outputStream.write(b);
            } else {
                MLLPDriver.this._outputBuffer.write(b);
            }
        }

        public void write(byte[] b) throws IOException {
            if (!MLLPDriver.this._sending && MLLPDriver.this._clearToSend) {
                MLLPDriver.this.beginSending();
            }
            if (MLLPDriver.this._sending) {
                MLLPDriver.this._outputStream.write(b);
            } else {
                MLLPDriver.this._outputBuffer.write(b);
            }
        }

        public void write(byte[] b, int offset, int length) throws IOException {
            if (!MLLPDriver.this._sending && MLLPDriver.this._clearToSend) {
                MLLPDriver.this.beginSending();
            }
            if (MLLPDriver.this._sending) {
                MLLPDriver.this._outputStream.write(b, offset, length);
            } else {
                MLLPDriver.this._outputBuffer.write(b, offset, length);
            }
        }

        public void flush() throws IOException {
            if (!MLLPDriver.this._sending && MLLPDriver.this._clearToSend) {
                MLLPDriver.this.beginSending();
            }
        }

        public void close() throws IOException {
            MLLPDriver.this._outputStream.close();
        }
    };

    public MLLPDriver(InputStream inputStream, OutputStream outputStream, boolean clearToSend) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        this._inputStream = inputStream;
        this._outputStream = outputStream;
        this._clearToSend = clearToSend;
        this._sending = false;
        this._receiving = false;
        this._inputClosed = false;
    }

    private void beginSending() throws IOException {
        if (this._sending) {
            throw new IllegalStateException("sending already");
        }
        this._outputStream.write(11);
        this._sending = true;
        if (this._outputBuffer.size() > 0) {
            this._outputBuffer.writeTo(this._outputStream);
            this._outputBuffer.reset();
        }
    }

    private void endSending() throws IOException {
        if (!this._sending) {
            throw new IllegalStateException("not sending");
        }
        this._proxyOutputStream.flush();
        this._outputStream.write(EOT);
        this._outputStream.flush();
        this._sending = false;
        this._clearToSend = false;
    }

    private void beginReceiving() throws IOException {
        if (this._receiving) {
            throw new IllegalStateException("receiving already");
        }
        if (this._sending) {
            throw new IllegalStateException("still sending");
        }
        if (!this._inputClosed) {
            int b = 0;
            while (b != 11) {
                if (b == -1) {
                    this._inputClosed = true;
                    return;
                }
                b = this._inputStream.read();
            }
            this._receiving = true;
        }
    }

    private void endReceiving() throws IOException {
        if (this._sending) {
            throw new IllegalStateException("still sending");
        }
        if (this._receiving && !this._inputClosed) {
            int b = 0;
            while (b != EOT[1]) {
                if (b == -1) {
                    this._inputClosed = true;
                }
                b = this._inputStream.read();
            }
            this._receiving = false;
            this._clearToSend = true;
        }
        if (this._outputBuffer.size() > 0) {
            this.beginSending();
        }
    }

    public boolean inputClosed() {
        return this._inputClosed;
    }

    public boolean hasMoreInput() throws IOException {
        if (this._inputClosed) {
            return false;
        }
        if (this._sending) {
            this.endSending();
        }
        if (!this._receiving) {
            this.beginReceiving();
        }
        return !this._inputClosed;
    }

    public void turn() throws IOException {
        this._proxyOutputStream.flush();
        if (this._sending) {
            this.endSending();
        }
    }

    public void discardPendingOutput() throws IOException {
        this._outputBuffer.reset();
    }

    public InputStream getInputStream() {
        return this._proxyInputStream;
    }

    public OutputStream getOutputStream() {
        return this._proxyOutputStream;
    }

    public void close() throws IOException {
        this._proxyInputStream.close();
        this._proxyOutputStream.close();
    }

    public static void main(String[] args) {
        try {
            MLLPDriver driver = new MLLPDriver(System.in, System.out, true);
            InputStream in = driver.getInputStream();
            PrintStream out = new PrintStream(driver.getOutputStream());
            out.println("hello, pleased to meet you");
            driver.turn();
            while (driver.hasMoreInput()) {
                StringBuffer sb = new StringBuffer();
                int c = in.read();
                while (c != -1) {
                    sb.append((char)c);
                    c = in.read();
                }
                out.println("Let me read this back to you, you said " + sb.toString());
            }
        }
        catch (Exception ex) {
            System.err.println("EXEXE");
            ex.printStackTrace(System.err);
        }
    }
}

